//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2018 uniCenta
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Suppliers.Reports.Creditors");
report.setReport("/com/openbravo/reports/suppliers_creditors");
report.setResourceBundle("com/openbravo/reports/suppliers_messages");

report.setSentence("SELECT ID, TAXID, NAME, ADDRESS, CURDEBT, CURDATE " +
                   "FROM SUPPLIERS " +
                   "WHERE VISIBLE = " + app.getSession().DB.TRUE() + " AND ?(QBF_FILTER)" +
                   "ORDER BY NAME ");

report.addParameter("CURDATE");
report.addParameter("CURDATE");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());
report.addQBFFilter(paramdates);

report.addParameter("ID");
report.addParameter("NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsSuppliers());

report.addField("ID", com.openbravo.data.loader.Datas.STRING);
report.addField("TAXID", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("ADDRESS", com.openbravo.data.loader.Datas.STRING);
report.addField("CURDEBT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CURDATE", com.openbravo.data.loader.Datas.TIMESTAMP);

report;