/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.panels;

import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.ComboBoxValModel;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.data.user.EditorRecord;
import com.openbravo.editor.JEditorCurrency;
import com.openbravo.editor.JEditorKeys;
import com.openbravo.editor.JEditorString;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public final class PaymentsEditor
extends JPanel
implements EditorRecord {
    private final ComboBoxValModel m_ReasonModel;
    private String m_sId;
    private String m_sPaymentId;
    private Date datenew;
    private final AppView m_App;
    private String m_sNotes;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JEditorCurrency jTotal;
    private JEditorKeys m_jKeys;
    private JEditorString m_jNotes;
    private JComboBox m_jreason;

    public PaymentsEditor(AppView oApp, DirtyManager dirty) {
        this.m_App = oApp;
        this.initComponents();
        this.m_ReasonModel = new ComboBoxValModel();
        this.m_ReasonModel.add(new PaymentReasonPositive("cashin", AppLocal.getIntString("transpayment.cashin")));
        this.m_ReasonModel.add(new PaymentReasonNegative("cashout", AppLocal.getIntString("transpayment.cashout")));
        this.m_jreason.setModel(this.m_ReasonModel);
        this.jTotal.addEditorKeys(this.m_jKeys);
        this.m_jreason.addActionListener(dirty);
        this.jTotal.addPropertyChangeListener("Text", dirty);
        this.m_jNotes.addPropertyChangeListener("Text", dirty);
        this.m_jNotes.addEditorKeys(this.m_jKeys);
        this.writeValueEOF();
    }

    @Override
    public void writeValueEOF() {
        this.m_sId = null;
        this.m_sPaymentId = null;
        this.datenew = null;
        this.setReasonTotal(null, null);
        this.m_jreason.setEnabled(false);
        this.jTotal.setEnabled(false);
        this.m_sNotes = null;
        this.m_jNotes.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_sId = null;
        this.m_sPaymentId = null;
        this.datenew = null;
        this.setReasonTotal("cashin", null);
        this.m_jreason.setEnabled(true);
        this.jTotal.setEnabled(true);
        this.jTotal.activate();
        this.m_sNotes = null;
        this.m_jNotes.setEnabled(true);
        this.m_jNotes.setText(this.m_sNotes);
    }

    @Override
    public void writeValueDelete(Object value) {
        Object[] payment = (Object[])value;
        this.m_sId = (String)payment[0];
        this.datenew = (Date)payment[2];
        this.m_sPaymentId = (String)payment[3];
        this.setReasonTotal(payment[4], payment[5]);
        this.m_jreason.setEnabled(false);
        this.jTotal.setEnabled(false);
        this.m_sNotes = (String)payment[6];
        this.m_jNotes.setEnabled(false);
    }

    @Override
    public void writeValueEdit(Object value) {
        Object[] payment = (Object[])value;
        this.m_sId = (String)payment[0];
        this.datenew = (Date)payment[2];
        this.m_sPaymentId = (String)payment[3];
        this.setReasonTotal(payment[4], payment[5]);
        this.m_jreason.setEnabled(false);
        this.jTotal.setEnabled(false);
        this.jTotal.activate();
        this.m_sNotes = (String)payment[6];
        this.m_jNotes.setEnabled(false);
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] payment = new Object[7];
        payment[0] = this.m_sId == null ? UUID.randomUUID().toString() : this.m_sId;
        payment[1] = this.m_App.getActiveCashIndex();
        payment[2] = this.datenew == null ? new Date() : this.datenew;
        payment[3] = this.m_sPaymentId == null ? UUID.randomUUID().toString() : this.m_sPaymentId;
        payment[4] = this.m_ReasonModel.getSelectedKey();
        PaymentReason reason = (PaymentReason)this.m_ReasonModel.getSelectedItem();
        Double dtotal = this.jTotal.getDoubleValue();
        payment[5] = reason == null ? dtotal : reason.addSignum(dtotal);
        String snotes = "";
        this.m_sNotes = this.m_jNotes.getText();
        payment[6] = this.m_sNotes == null ? snotes : this.m_sNotes;
        return payment;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void refresh() {
    }

    private void setReasonTotal(Object reasonfield, Object totalfield) {
        this.m_ReasonModel.setSelectedKey(reasonfield);
        PaymentReason reason = (PaymentReason)this.m_ReasonModel.getSelectedItem();
        if (reason == null) {
            this.jTotal.setDoubleValue((Double)totalfield);
        } else {
            this.jTotal.setDoubleValue(reason.positivize((Double)totalfield));
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.m_jreason = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTotal = new JEditorCurrency();
        this.m_jNotes = new JEditorString();
        this.jPanel2 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.setLayout(new BorderLayout());
        this.jLabel5.setFont(new Font("Arial", 0, 14));
        this.jLabel5.setText(AppLocal.getIntString("label.paymentreason"));
        this.jLabel5.setPreferredSize(new Dimension(110, 30));
        this.m_jreason.setFont(new Font("Arial", 0, 14));
        this.m_jreason.setFocusable(false);
        this.m_jreason.setPreferredSize(new Dimension(200, 30));
        this.jLabel3.setFont(new Font("Arial", 0, 14));
        this.jLabel3.setText(AppLocal.getIntString("label.paymenttotal"));
        this.jLabel3.setPreferredSize(new Dimension(110, 30));
        this.jTotal.setFont(new Font("Arial", 0, 14));
        this.jTotal.setPreferredSize(new Dimension(200, 30));
        this.m_jNotes.setFont(new Font("Arial", 0, 14));
        this.m_jNotes.setPreferredSize(new Dimension(132, 100));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_jNotes, -1, 234, Short.MAX_VALUE).addComponent(this.m_jreason, -2, -1, -2).addComponent(this.jTotal, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.m_jreason, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTotal, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.m_jNotes, -2, -1, -2).addContainerGap()));
        this.add((Component)this.jPanel3, "Center");
        this.jPanel2.setLayout(new BorderLayout());
        this.m_jKeys.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PaymentsEditor.this.m_jKeysPropertyChange(evt);
            }
        });
        this.jPanel2.add((Component)this.m_jKeys, "North");
        this.add((Component)this.jPanel2, "After");
    }

    private void m_jKeysPropertyChange(PropertyChangeEvent evt) {
    }

    private static class PaymentReasonNegative
    extends PaymentReason {
        public PaymentReasonNegative(String key, String text) {
            super(key, text);
        }

        @Override
        public Double positivize(Double d) {
            return d == null ? null : new Double(-d.doubleValue());
        }

        @Override
        public Double addSignum(Double d) {
            if (d == null) {
                return null;
            }
            if (d > 0.0) {
                return new Double(-d.doubleValue());
            }
            return d;
        }
    }

    private static class PaymentReasonPositive
    extends PaymentReason {
        public PaymentReasonPositive(String key, String text) {
            super(key, text);
        }

        @Override
        public Double positivize(Double d) {
            return d;
        }

        @Override
        public Double addSignum(Double d) {
            if (d == null) {
                return null;
            }
            if (d < 0.0) {
                return new Double(-d.doubleValue());
            }
            return d;
        }
    }

    private static abstract class PaymentReason
    implements IKeyed {
        private String m_sKey;
        private String m_sText;

        public PaymentReason(String key, String text) {
            this.m_sKey = key;
            this.m_sText = text;
        }

        @Override
        public Object getKey() {
            return this.m_sKey;
        }

        public abstract Double positivize(Double var1);

        public abstract Double addSignum(Double var1);

        public String toString() {
            return this.m_sText;
        }
    }
}

