//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.UserTip");
report.setReport("/com/openbravo/reports/usertips");
report.setResourceBundle("com/openbravo/reports/usertips_messages");

report.setSentence("SELECT people.NAME, MIN(receipts.DATENEW) AS STARTDATE, MAX(receipts.DATENEW) AS ENDDATE, SUM(payments.TIP) AS TOTAL " +
                "FROM people, receipts, tickets, payments WHERE people.ID = tickets.PERSON AND receipts.ID = tickets.ID AND tickets.ID = payments.RECEIPT AND ?(QBF_FILTER) " +
                "GROUP BY people.NAME ORDER BY people.NAME");
report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());

report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("STARTDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("ENDDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

report;
