//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.InventoryBroken");
report.setReport("/com/openbravo/reports/inventoryb");
report.setResourceBundle("com/openbravo/reports/inventory_messages");

report.setSentence("SELECT " +
        "stockcurrent.LOCATION AS LOCATIONID, locations.NAME AS LOCATIONNAME, " +
        "products.REFERENCE, products.NAME AS PRODUCTNAME, " +
        "products.CATEGORY, categories.NAME AS CATEGORYNAME, " +
        "products.SUPPLIER, " +
        "SUM(stockcurrent.UNITS) AS UNITS, " +
        "products.PRICEBUY, products.PRICESELL, " +
        "COALESCE(products.STOCKVOLUME, 0) AS STOCKVOLUME, " +
        "COALESCE(products.STOCKCOST, 0) AS STOCKCOST, " +
        "COALESCE(stocklevel.STOCKSECURITY, 0) AS STOCKSECURITY, " +
        "COALESCE(stocklevel.STOCKMAXIMUM, 0) AS STOCKMAXIMUM, " +
        "suppliers.NAME AS SUPPLIERNAME, uom.NAME AS UOM " +
    "FROM (((((stockcurrent stockcurrent CROSS JOIN locations locations " +
            "ON (stockcurrent.LOCATION = locations.id)) " +
            "CROSS JOIN products products ON (stockcurrent.PRODUCT = products.ID)) " +
            "CROSS JOIN categories categories ON (products.CATEGORY = categories.ID)) " +
        "RIGHT OUTER JOIN suppliers suppliers ON (suppliers.id = products.SUPPLIER)) " +
            "INNER JOIN uom uom ON (uom.id = products.UOM)) " +
        "LEFT OUTER JOIN stocklevel stocklevel ON (stockcurrent.LOCATION = stocklevel.LOCATION) " +
            "AND (stockcurrent.PRODUCT = stocklevel.PRODUCT) " +
    "WHERE ?(QBF_FILTER)" +      
    "GROUP BY stockcurrent.LOCATION, locations.NAME, products.REFERENCE, products.NAME, " +
        "products.CATEGORY, categories.NAME, products.PRICEBUY, products.PRICESELL, " +
        "products.STOCKVOLUME, products.STOCKCOST, stocklevel.STOCKSECURITY, stocklevel.STOCKMAXIMUM " +
    "HAVING stocklevel.STOCKSECURITY IS NOT NULL AND stocklevel.STOCKSECURITY >= SUM(stockcurrent.UNITS) " +
    "ORDER BY CATEGORYNAME ASC, PRODUCTNAME ASC, LOCATIONID ASC");

report.addParameter("products.NAME");
report.addParameter("products.CATEGORY");
report.addParameter("products.CODE");
report.addParameter("stockcurrent.UNITS");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter1());

report.addParameter("suppliers.ID");
report.addParameter("suppliers.NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsSuppliers());

report.addParameter("stockcurrent.LOCATION");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());

report.addField("LOCATIONID", com.openbravo.data.loader.Datas.STRING);
report.addField("LOCATIONNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORY", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("SUPPLIER", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICEBUY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKVOLUME", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKCOST", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKSECURITY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STOCKMAXIMUM", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("SUPPLIERNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UOM", com.openbravo.data.loader.Datas.STRING);

report;