//    uniCenta oPOS - Touch friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.


report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Top10Sales");
report.setReport("/com/openbravo/reports/sales_chart_top10sales");
report.setResourceBundle("com/openbravo/reports/sales_chart_top10sales_messages");

report.setSentence(
            "SELECT " +
			"products.NAME,ROUND(SUM(ticketlines.UNITS)) AS UNITS, " +
			"products.PRICEBUY,products.PRICESELL, " +
                        "ROUND(SUM(ticketlines.PRICE * ticketlines.UNITS)) AS SUBTOTAL, " +
                        "ROUND(SUM((ticketlines.PRICE * ticketlines.UNITS) * taxes.RATE)) AS TAXES, " +
                        "ROUND(SUM(ticketlines.PRICE * ticketlines.UNITS) + SUM((ticketlines.PRICE * ticketlines.UNITS) * taxes.RATE)) AS GROSSTOTAL " +
			"FROM ticketlines " +
			"LEFT OUTER JOIN products ON ticketlines.PRODUCT = products.ID " +
			"LEFT OUTER JOIN tickets ON tickets.ID = ticketlines.TICKET " +
                        "LEFT OUTER JOIN receipts ON receipts.ID = tickets.ID, taxes " +
			"WHERE receipts.ID = tickets.ID " +
                        "AND tickets.ID = ticketlines.TICKET " +
                        "AND ticketlines.PRODUCT = products.ID " +
                        "AND ticketlines.TAXID = taxes.ID " +
                        "AND ?(QBF_FILTER) " +
			"GROUP BY products.NAME,products.PRICEBUY,products.PRICESELL " +
			"ORDER BY GROSSTOTAL DESC " +
			"LIMIT 10");
			
report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICEBUY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("SUBTOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TAXES", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("GROSSTOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report;