//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Customers.Reports.Vouchers");
report.setReport("/com/openbravo/reports/customers_vouchers");
report.setResourceBundle("com/openbravo/reports/customers_messages");

report.setSentence("SELECT customers.name AS CNAME, " +
       "vouchers.voucher_number AS VNUM, " +
       "vouchers.amount AS VAMOUNT, " +
       "vouchers.status AS VSTATUS, " +
       "payments.total AS TOTAL, " +
       "tickets.ticketid AS TICKETID, " +
       "receipts.datenew AS TDATE " +
"FROM (((tickets tickets " +
        "INNER JOIN receipts receipts " +
           "ON (tickets.id = receipts.id)) " +
       "INNER JOIN payments payments " +
          "ON     (payments.receipt = receipts.id) " +
             "AND (tickets.id = payments.receipt)) " +
      "INNER JOIN vouchers vouchers " +
         "ON (payments.voucher = vouchers.voucher_number)) " +
     "INNER JOIN customers customers " +
        "ON (tickets.customer = customers.id) " +
"WHERE ?(QBF_FILTER) " +
"ORDER BY customers.name ");

report.addParameter("ID");
report.addParameter("NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("CNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("VNUM", com.openbravo.data.loader.Datas.STRING);
report.addField("VAMOUNT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("VSTATUS", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TICKETID", com.openbravo.data.loader.Datas.STRING);
report.addField("TDATE", com.openbravo.data.loader.Datas.TIMESTAMP);

report;