//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Customers.Reports.Diary");
report.setReport("/com/openbravo/reports/customers_diary");
report.setResourceBundle("com/openbravo/reports/customers_messages");

report.setSentence("SELECT " +
            "receipts.DATENEW, " +
            "tickets.TICKETID, " +
            "payments.PAYMENT, " +
            "payments.TOTAL, " +
            "customers.TAXID, " +
            "customers.NAME " +
        "FROM receipts, tickets, customers, payments " +
        "WHERE receipts.ID = tickets.ID AND receipts.ID = payments.RECEIPT " +
            "AND tickets.CUSTOMER = customers.ID " +
// JG AUG 2014 
//            "AND (payments.PAYMENT = 'debt' OR payments.PAYMENT = 'debtpaid') " +
            "AND ?(QBF_FILTER) " +
        "ORDER BY customers.NAME, receipts.DATENEW DESC");

report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("customers.ID");
report.addParameter("customers.NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("DATENEW", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("TICKETID", com.openbravo.data.loader.Datas.STRING);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TAXID", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);

report;