/*
 * Decompiled with CFR 0.152.
 */
package com.unicenta.orderpop;

import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.util.AltEncrypter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class OrderPop
extends Application {
    private static final Logger logger = Logger.getLogger(OrderPop.class.getName());
    private ExecutorService databaseExecutor;
    private Future databaseSetupFuture;

    public static void main(String[] args) {
        OrderPop.launch((String[])args);
    }

    public void init() throws Exception {
        this.databaseExecutor = Executors.newFixedThreadPool(1, new DatabaseThreadFactory());
        DBSetupTask setup = new DBSetupTask();
        this.databaseSetupFuture = this.databaseExecutor.submit((Runnable)((Object)setup));
    }

    public void stop() throws Exception {
        this.databaseExecutor.shutdown();
        if (!this.databaseExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
            logger.info("DB thread time-out + 3 sec's not shut down clean");
        }
        Platform.exit();
    }

    public void start(Stage stage) throws InterruptedException, ExecutionException {
        this.databaseSetupFuture.get();
        ListView orderView = new ListView();
        ProgressIndicator databaseActivityIndicator = new ProgressIndicator();
        Image fetchO = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/com/openbravo/images/resources.png"));
        Button fetchOrders = new Button("", (Node)new ImageView(fetchO));
        databaseActivityIndicator.setVisible(false);
        fetchOrders.setOnAction(event -> this.fetchDBOrdersListView(fetchOrders, databaseActivityIndicator, (ListView<String>)orderView));
        VBox layout = new VBox(10.0);
        layout.setStyle("-fx-background-color: aliceblue; -fx-padding: 5;");
        layout.getChildren().setAll((Object[])new Node[]{new HBox(10.0, new Node[]{fetchOrders, databaseActivityIndicator}), orderView});
        layout.setPrefHeight(300.0);
        layout.setPrefWidth(500.0);
        stage.getIcons().add((Object)new Image("/com/openbravo/images/unicentaopos.png"));
        stage.setTitle("Orders Waiting...");
        stage.setScene(new Scene((Parent)layout));
        stage.setAlwaysOnTop(true);
        stage.show();
    }

    private void fetchDBOrdersListView(Button triggerButton, ProgressIndicator databaseActivityIndicator, ListView<String> listView) {
        FetchOrdersTask fetchOrdersTask = new FetchOrdersTask();
        triggerButton.disableProperty().bind((ObservableValue)fetchOrdersTask.runningProperty());
        databaseActivityIndicator.visibleProperty().bind((ObservableValue)fetchOrdersTask.runningProperty());
        databaseActivityIndicator.progressProperty().bind((ObservableValue)fetchOrdersTask.progressProperty());
        fetchOrdersTask.setOnSucceeded(t -> listView.setItems((ObservableList)fetchOrdersTask.getValue()));
        listView.setStyle("-fx-font-size: 14px;");
        this.databaseExecutor.submit((Runnable)((Object)fetchOrdersTask));
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        logger.info("Get DB connection");
        String url = AppConfig.getInstance().getProperty("db.URL") + AppConfig.getInstance().getProperty("db.schema") + AppConfig.getInstance().getProperty("db.options");
        String sDBUser = AppConfig.getInstance().getProperty("db.user");
        String sDBPassword = AppConfig.getInstance().getProperty("db.password");
        if (sDBUser != null && sDBPassword != null && sDBPassword.startsWith("crypt:")) {
            AltEncrypter cypher = new AltEncrypter("cypherkey" + sDBUser);
            sDBPassword = cypher.decrypt(sDBPassword.substring(6));
        }
        return DriverManager.getConnection(url, sDBUser, sDBPassword);
    }

    static class DatabaseThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);

        DatabaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Database-Connection-" + poolNumber.getAndIncrement() + "-thread");
            thread.setDaemon(true);
            return thread;
        }
    }

    class DBSetupTask
    extends DBTask {
        DBSetupTask() {
        }

        protected Void call() throws Exception {
            try (Connection con = OrderPop.this.getConnection();){
                if (!this.schemaExists(con)) {
                    // empty if block
                }
            }
            return null;
        }

        private boolean schemaExists(Connection con) {
            logger.info("Check for Orders table");
            try {
                Statement st = con.createStatement();
                st.executeQuery("select count(*) from orders");
                logger.info("Orders table exists");
            }
            catch (SQLException ex) {
                logger.info("Create Orders table");
                return false;
            }
            return true;
        }
    }

    class FetchOrdersTask
    extends DBTask<ObservableList<String>> {
        FetchOrdersTask() {
        }

        protected ObservableList<String> call() throws Exception {
            Thread.sleep(1000L);
            try (Connection con = OrderPop.this.getConnection();){
                ObservableList<String> observableList = this.fetchOrders(con);
                return observableList;
            }
        }

        private ObservableList<String> fetchOrders(Connection con) throws SQLException {
            logger.info("Fetch Orders from DB");
            ObservableList orders = FXCollections.observableArrayList();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT orderid, qty, ordertime, details FROM orders ORDER BY ordertime, orderid");
            while (rs.next()) {
                orders.add((Object)(rs.getString("orderid") + " - " + rs.getString("ordertime") + " - " + rs.getString("qty") + " * " + rs.getString("details")));
            }
            logger.info("Found " + orders.size() + " orders");
            return orders;
        }
    }

    abstract class DBTask<T>
    extends Task<T> {
        DBTask() {
            this.setOnFailed(t -> logger.log(Level.SEVERE, null, this.getException()));
        }
    }
}

