/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.scale;

import com.openbravo.pos.scale.Scale;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public class ScaleAcomPC100
implements Scale,
SerialPortEventListener {
    private CommPortIdentifier m_PortIdPrinter;
    private SerialPort m_CommPortPrinter;
    private final String m_sPortScale;
    private OutputStream m_out;
    private InputStream m_in;
    private static final int SCALE_READY = 0;
    private static final int SCALE_READING = 1;
    private static final int SCALE_READINGDECIMALS = 2;
    private double m_dWeightBuffer;
    private double m_dWeightDecimals;
    private int m_iStatusScale;
    private String m_sScaleReading;

    public ScaleAcomPC100(String sPortPrinter) {
        this.m_sPortScale = sPortPrinter;
        this.m_out = null;
        this.m_in = null;
        this.m_iStatusScale = 0;
        this.m_dWeightBuffer = 0.0;
        this.m_dWeightDecimals = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double readWeight() {
        ScaleAcomPC100 scaleAcomPC100 = this;
        synchronized (scaleAcomPC100) {
            if (this.m_iStatusScale != 0) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_iStatusScale != 0) {
                    this.m_iStatusScale = 0;
                }
            }
            this.m_dWeightBuffer = 0.0;
            this.m_dWeightDecimals = 1.0;
            this.write(new byte[]{87, 13});
            this.flush();
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_iStatusScale == 0) {
                double dWeight = this.m_dWeightBuffer / this.m_dWeightDecimals;
                this.m_dWeightBuffer = 0.0;
                this.m_dWeightDecimals = 1.0;
                return dWeight;
            }
            this.m_iStatusScale = 0;
            this.m_dWeightBuffer = 0.0;
            this.m_dWeightDecimals = 1.0;
            return 0.0;
        }
    }

    private void flush() {
        try {
            this.m_out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] data) {
        try {
            if (this.m_out == null) {
                this.m_PortIdPrinter = CommPortIdentifier.getPortIdentifier((String)this.m_sPortScale);
                this.m_CommPortPrinter = (SerialPort)this.m_PortIdPrinter.open("PORTID", 2000);
                this.m_out = this.m_CommPortPrinter.getOutputStream();
                this.m_in = this.m_CommPortPrinter.getInputStream();
                this.m_CommPortPrinter.addEventListener((SerialPortEventListener)this);
                this.m_CommPortPrinter.notifyOnDataAvailable(true);
                this.m_CommPortPrinter.setSerialPortParams(9600, 7, 1, 2);
            }
            this.m_out.write(data);
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | TooManyListenersException throwable) {
            // empty catch block
        }
    }

    public void serialEvent(SerialPortEvent e) {
        switch (e.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    int i = this.m_in.available();
                    byte[] readBuffer = new byte[i];
                    if (i > 0) {
                        this.m_in.read(readBuffer);
                    }
                    this.m_sScaleReading = this.m_sScaleReading + new String(readBuffer);
                    try {
                        int start = this.m_sScaleReading.indexOf(10);
                        int end = this.m_sScaleReading.indexOf(3);
                        if (start < 0 || end < 0) break;
                        start = this.m_sScaleReading.indexOf(10);
                        end = this.m_sScaleReading.indexOf(75);
                        this.m_dWeightBuffer = Double.parseDouble(this.m_sScaleReading.substring(start + 1, end));
                        this.m_sScaleReading = "";
                    }
                    catch (IndexOutOfBoundsException ex) {
                        System.out.println("IndexOutOfBoundsException, message not complete yet. Waiting for more data.");
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

