/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales.restaurant;

import com.alee.laf.label.WebLabel;
import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.gui.NullIcon;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.StaticSentence;
import com.openbravo.pos.customers.CustomerInfo;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.DataLogicSales;
import com.openbravo.pos.forms.DataLogicSystem;
import com.openbravo.pos.sales.DataLogicReceipts;
import com.openbravo.pos.sales.JTicketsBag;
import com.openbravo.pos.sales.SharedTicketInfo;
import com.openbravo.pos.sales.TicketsEditor;
import com.openbravo.pos.sales.restaurant.Floor;
import com.openbravo.pos.sales.restaurant.JTicketsBagRestaurant;
import com.openbravo.pos.sales.restaurant.JTicketsBagRestaurantRes;
import com.openbravo.pos.sales.restaurant.Place;
import com.openbravo.pos.sales.restaurant.RestaurantDBUtils;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class JTicketsBagRestaurantMap
extends JTicketsBag {
    private List<Place> m_aplaces;
    private List<Floor> m_afloors;
    private JTicketsBagRestaurant m_restaurantmap;
    private final JTicketsBagRestaurantRes m_jreservations;
    private Place m_PlaceCurrent;
    private ServerCurrent m_ServerCurrent;
    private Place m_PlaceClipboard;
    private CustomerInfo customer;
    private DataLogicReceipts dlReceipts = null;
    private DataLogicSales dlSales = null;
    private DataLogicSystem dlSystem = null;
    private final RestaurantDBUtils restDB;
    private static final Icon ICO_OCU_SM = new ImageIcon(Place.class.getResource("/com/openbravo/images/edit_group_sm.png"));
    private static final Icon ICO_WAITER = new NullIcon(1, 1);
    private static final Icon ICO_FRE = new NullIcon(22, 22);
    private String waiterDetails;
    private String customerDetails;
    private String tableName;
    private Boolean transBtns;
    private Boolean actionEnabled = true;
    private int newX;
    private int newY;
    private AppView m_app;
    private Boolean showLayout = false;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel m_jPanelMap;
    private JLabel m_jText;
    private JButton m_jbtnLayout;
    private JButton m_jbtnRefresh;
    private JButton m_jbtnReservations;
    private JButton m_jbtnSave;
    private WebLabel webLblautoRefresh;

    public JTicketsBagRestaurantMap(AppView app, TicketsEditor panelticket) {
        super(app, panelticket);
        StaticSentence sent;
        this.restDB = new RestaurantDBUtils(app);
        this.transBtns = AppConfig.getInstance().getBoolean("table.transbtn");
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.openbravo.pos.sales.DataLogicReceipts");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSales");
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSystem");
        this.m_restaurantmap = new JTicketsBagRestaurant(app, this);
        this.m_PlaceCurrent = null;
        this.m_PlaceClipboard = null;
        this.customer = null;
        try {
            sent = new StaticSentence(app.getSession(), "SELECT ID, NAME, IMAGE FROM floors ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(Floor.class));
            this.m_afloors = sent.list();
        }
        catch (BasicException eD) {
            this.m_afloors = new ArrayList<Floor>();
        }
        try {
            sent = new StaticSentence(app.getSession(), "SELECT ID, NAME, SEATS, X, Y, FLOOR, CUSTOMER, WAITER, TICKETID, TABLEMOVED FROM places ORDER BY FLOOR", null, (SerializerRead)new SerializerReadClass(Place.class));
            this.m_aplaces = sent.list();
        }
        catch (BasicException eD) {
            this.m_aplaces = new ArrayList<Place>();
        }
        this.initComponents();
        this.m_jbtnSave.setVisible(false);
        if (this.m_afloors.size() > 1) {
            JTabbedPane jTabFloors = new JTabbedPane();
            jTabFloors.applyComponentOrientation(this.getComponentOrientation());
            jTabFloors.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            jTabFloors.setTabLayoutPolicy(1);
            jTabFloors.setFocusable(false);
            jTabFloors.setRequestFocusEnabled(false);
            this.m_jPanelMap.add((Component)jTabFloors, "Center");
            this.m_afloors.stream().map(f -> {
                f.getContainer().applyComponentOrientation(this.getComponentOrientation());
                return f;
            }).forEach(f -> {
                JScrollPane jScrCont = new JScrollPane();
                jScrCont.applyComponentOrientation(this.getComponentOrientation());
                JPanel jPanCont = new JPanel();
                jPanCont.applyComponentOrientation(this.getComponentOrientation());
                jTabFloors.addTab(f.getName(), f.getIcon(), jScrCont);
                jScrCont.setViewportView(jPanCont);
                jPanCont.add(f.getContainer());
            });
        } else if (this.m_afloors.size() == 1) {
            Floor f2 = this.m_afloors.get(0);
            f2.getContainer().applyComponentOrientation(this.getComponentOrientation());
            JPanel jPlaces = new JPanel();
            jPlaces.applyComponentOrientation(this.getComponentOrientation());
            jPlaces.setLayout(new BorderLayout());
            jPlaces.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 5, 5, 5)), new TitledBorder(f2.getName())));
            JScrollPane jScrCont = new JScrollPane();
            jScrCont.applyComponentOrientation(this.getComponentOrientation());
            JPanel jPanCont = new JPanel();
            jPanCont.applyComponentOrientation(this.getComponentOrientation());
            this.m_jPanelMap.add((Component)jPlaces, "Center");
            jPlaces.add((Component)jScrCont, "Center");
            jScrCont.setViewportView(jPanCont);
            jPanCont.add(f2.getContainer());
        }
        Floor currfloor = null;
        for (final Place pl : this.m_aplaces) {
            int iFloor = 0;
            if (currfloor == null || !currfloor.getID().equals(pl.getFloor())) {
                while (!(currfloor = this.m_afloors.get(iFloor++)).getID().equals(pl.getFloor())) {
                }
            }
            currfloor.getContainer().add(pl.getButton());
            pl.setButtonBounds();
            if (this.transBtns.booleanValue()) {
                pl.getButton().setOpaque(false);
                pl.getButton().setContentAreaFilled(false);
                pl.getButton().setBorderPainted(false);
            }
            pl.getButton().addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent E) {
                    if (!JTicketsBagRestaurantMap.this.actionEnabled.booleanValue()) {
                        if (pl.getDiffX() == 0) {
                            pl.setDiffX(pl.getButton().getX() - pl.getX());
                            pl.setDiffY(pl.getButton().getY() - pl.getY());
                        }
                        JTicketsBagRestaurantMap.this.newX = E.getX() + pl.getButton().getX();
                        JTicketsBagRestaurantMap.this.newY = E.getY() + pl.getButton().getY();
                        pl.getButton().setBounds(JTicketsBagRestaurantMap.this.newX + pl.getDiffX(), JTicketsBagRestaurantMap.this.newY + pl.getDiffY(), pl.getButton().getWidth(), pl.getButton().getHeight());
                        pl.setX(JTicketsBagRestaurantMap.this.newX);
                        pl.setY(JTicketsBagRestaurantMap.this.newY);
                    }
                }
            });
            pl.getButton().addActionListener(new MyActionListener(pl));
        }
        this.m_jreservations = new JTicketsBagRestaurantRes(app, this);
        this.add((Component)this.m_jreservations, "res");
        this.showLayout = this.m_App.getAppUserView().getUser().hasPermission("sales.Layout");
        if (this.showLayout.booleanValue()) {
            this.m_jbtnLayout.setVisible(true);
            this.m_jbtnSave.setVisible(false);
        } else {
            this.m_jbtnLayout.setVisible(false);
            this.m_jbtnSave.setVisible(false);
        }
        if (this.m_App.getProperties().getProperty("till.autoRefreshTableMap").equals("true")) {
            this.webLblautoRefresh.setText(ResourceBundle.getBundle("pos_messages").getString("label.autoRefreshTableMapTimerON"));
            Timer autoRefreshTimer = new Timer(Integer.parseInt(this.m_App.getProperties().getProperty("till.autoRefreshTimer")) * 1000, new tableMapRefresh());
            autoRefreshTimer.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                autoRefreshTimer.stop();
            }
        } else {
            this.webLblautoRefresh.setText(ResourceBundle.getBundle("pos_messages").getString("label.autoRefreshTableMapTimerOFF"));
        }
    }

    @Override
    public void activate() {
        this.showLayout = this.m_App.getAppUserView().getUser().hasPermission("sales.Layout");
        if (this.showLayout.booleanValue()) {
            this.m_jbtnLayout.setVisible(true);
            this.m_jbtnSave.setVisible(false);
        } else {
            this.m_jbtnLayout.setVisible(false);
            this.m_jbtnSave.setVisible(false);
        }
        this.m_PlaceClipboard = null;
        this.customer = null;
        this.loadTickets();
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
        this.m_restaurantmap.activate();
        this.showView("map");
    }

    @Override
    public boolean deactivate() {
        if (this.viewTables()) {
            this.m_PlaceClipboard = null;
            this.customer = null;
            if (this.m_PlaceCurrent != null) {
                try {
                    this.dlReceipts.updateSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket(), this.m_panelticket.getActiveTicket().getPickupId());
                    this.dlReceipts.unlockSharedTicket(this.m_PlaceCurrent.getId(), null);
                }
                catch (BasicException e) {
                    new MessageInf(e).show(this);
                }
                this.m_PlaceCurrent = null;
            }
            this.printState();
            this.m_panelticket.setActiveTicket(null, null);
            return true;
        }
        return false;
    }

    @Override
    protected JComponent getBagComponent() {
        return this.m_restaurantmap;
    }

    @Override
    protected JComponent getNullComponent() {
        return this;
    }

    public TicketInfo getActiveTicket() {
        return this.m_panelticket.getActiveTicket();
    }

    public void moveTicket() {
        if (this.m_PlaceCurrent != null) {
            try {
                this.dlReceipts.updateRSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket(), this.m_panelticket.getActiveTicket().getPickupId());
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_PlaceClipboard = this.m_PlaceCurrent;
            this.customer = null;
            this.m_PlaceCurrent = null;
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public boolean viewTables(CustomerInfo c) {
        if (this.m_jreservations.deactivate()) {
            this.showView("map");
            this.m_PlaceClipboard = null;
            this.customer = c;
            this.printState();
            return true;
        }
        return false;
    }

    public boolean viewTables() {
        return this.viewTables(null);
    }

    public void newTicket() {
        if (this.m_PlaceCurrent != null) {
            try {
                String m_lockState = null;
                m_lockState = this.dlReceipts.getLockState(this.m_PlaceCurrent.getId(), m_lockState);
                this.dlReceipts.getSharedTicket(this.m_PlaceCurrent.getId());
                if ("override".equals(m_lockState) || "locked".equals(m_lockState)) {
                    this.dlReceipts.updateSharedTicket(this.m_PlaceCurrent.getId(), this.m_panelticket.getActiveTicket(), this.m_panelticket.getActiveTicket().getPickupId());
                    this.dlReceipts.unlockSharedTicket(this.m_PlaceCurrent.getId(), null);
                    this.m_PlaceCurrent = null;
                } else {
                    JOptionPane.showMessageDialog(null, AppLocal.getIntString("message.sharedticketlockoverriden"), AppLocal.getIntString("title.editor"), 1);
                }
            }
            catch (BasicException ex) {
                Logger.getLogger(JTicketsBagRestaurantMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public String getTable() {
        String id = null;
        if (this.m_PlaceCurrent != null) {
            id = this.m_PlaceCurrent.getId();
        }
        return id;
    }

    public String getTableName() {
        String stableName = null;
        if (this.m_PlaceCurrent != null) {
            stableName = this.m_PlaceCurrent.getName();
        }
        return stableName;
    }

    @Override
    public void deleteTicket() {
        if (this.m_PlaceCurrent != null) {
            String id = this.m_PlaceCurrent.getId();
            try {
                this.dlReceipts.deleteSharedTicket(id);
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
            this.m_PlaceCurrent.setPeople(false);
            this.m_PlaceCurrent = null;
        }
        this.printState();
        this.m_panelticket.setActiveTicket(null, null);
    }

    public void changeServer() {
        if (this.m_ServerCurrent != null) {
            // empty if block
        }
    }

    public void loadTickets() {
        HashSet atickets = new HashSet();
        try {
            List<SharedTicketInfo> l = this.dlReceipts.getSharedTicketList();
            l.stream().forEach(ticket -> atickets.add(ticket.getId()));
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
        }
        this.m_aplaces.stream().forEach(table -> table.setPeople(atickets.contains(table.getId())));
    }

    private void printState() {
        String sDB = this.m_App.getProperties().getProperty("db.engine");
        if (this.m_PlaceClipboard == null) {
            if (this.customer == null) {
                this.m_jText.setText(null);
                this.m_aplaces.stream().map(place -> {
                    place.getButton().setEnabled(true);
                    return place;
                }).map(place -> {
                    this.tableName = this.m_App.getProperties().getProperty("table.tablecolour") == null ? "<style=font-size:9px;font-weight:bold;><font color = black>" + place.getName() + "</font></style>" : "<style=font-size:9px;font-weight:bold;><font color =" + this.m_App.getProperties().getProperty("table.tablecolour") + ">" + place.getName() + "</font></style>";
                    return place;
                }).map(place -> {
                    if (Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showwaiterdetails"))) {
                        this.waiterDetails = this.m_App.getProperties().getProperty("table.waitercolour") == null ? (this.restDB.getWaiterNameInTable(place.getName()) == null ? "" : "<style=font-size:9px;font-weight:bold;><font color = red>" + this.restDB.getWaiterNameInTableById(place.getId()) + "</font></style><br>") : (this.restDB.getWaiterNameInTable(place.getName()) == null ? "" : "<style=font-size:9px;font-weight:bold;><font color =" + this.m_App.getProperties().getProperty("table.waitercolour") + ">" + this.restDB.getWaiterNameInTableById(place.getId()) + "</font></style><br>");
                        place.getButton().setIcon(ICO_OCU_SM);
                    } else {
                        this.waiterDetails = "";
                    }
                    return place;
                }).map(place -> {
                    if (Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showcustomerdetails"))) {
                        place.getButton().setIcon(Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showwaiterdetails")) && this.restDB.getCustomerNameInTable(place.getName()) != null ? ICO_WAITER : ICO_OCU_SM);
                        this.customerDetails = this.m_App.getProperties().getProperty("table.customercolour") == null ? (this.restDB.getCustomerNameInTable(place.getName()) == null ? "" : "<style=font-size:9px;font-weight:bold;><font color = blue>" + this.restDB.getCustomerNameInTableById(place.getId()) + "</font></style><br>") : (this.restDB.getCustomerNameInTable(place.getName()) == null ? "" : "<style=font-size:9px;font-weight:bold;><font color =" + this.m_App.getProperties().getProperty("table.customercolour") + ">" + this.restDB.getCustomerNameInTableById(place.getId()) + "</font></style><br>");
                    } else {
                        this.customerDetails = "";
                    }
                    return place;
                }).map(place -> {
                    if (Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showwaiterdetails")) || Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showcustomerdetails"))) {
                        place.getButton().setText("<html><center>" + this.customerDetails + this.waiterDetails + this.tableName + "</html>");
                    } else {
                        this.tableName = this.m_App.getProperties().getProperty("table.tablecolour") == null ? "<style=font-size:10px;font-weight:bold;><font color = black>" + place.getName() + "</font></style>" : "<style=font-size:10px;font-weight:bold;><font color =" + this.m_App.getProperties().getProperty("table.tablecolour") + ">" + place.getName() + "</font></style>";
                        place.getButton().setText("<html><center>" + this.tableName + "</html>");
                    }
                    return place;
                }).filter(place -> !place.hasPeople()).forEach(place -> place.getButton().setIcon(ICO_FRE));
                this.m_jbtnReservations.setEnabled(true);
            } else {
                this.m_jText.setText(AppLocal.getIntString("label.restaurantcustomer", this.customer.getName()));
                this.m_aplaces.stream().forEach(place -> place.getButton().setEnabled(!place.hasPeople()));
                this.m_jbtnReservations.setEnabled(false);
            }
        } else {
            this.m_jText.setText(AppLocal.getIntString("label.restaurantmove", this.m_PlaceClipboard.getName()));
            this.m_aplaces.stream().forEach(place -> place.getButton().setEnabled(true));
            this.m_jbtnReservations.setEnabled(false);
        }
    }

    private TicketInfo getTicketInfo(Place place) {
        try {
            return this.dlReceipts.getSharedTicket(place.getId());
        }
        catch (BasicException e) {
            new MessageInf(e).show(this);
            return null;
        }
    }

    private void setActivePlace(Place place, TicketInfo ticket) {
        this.m_PlaceCurrent = place;
        this.m_panelticket.setActiveTicket(ticket, this.m_PlaceCurrent.getName());
        try {
            this.dlReceipts.lockSharedTicket(this.m_PlaceCurrent.getId(), "locked");
        }
        catch (BasicException ex) {
            Logger.getLogger(JTicketsBagRestaurantMap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void showView(String view) {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, view);
    }

    public void setButtonTextBags(String btnText) {
        this.m_PlaceClipboard.setButtonText(btnText);
    }

    private void initComponents() {
        this.m_jPanelMap = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jbtnReservations = new JButton();
        this.m_jbtnRefresh = new JButton();
        this.m_jText = new JLabel();
        this.m_jbtnLayout = new JButton();
        this.m_jbtnSave = new JButton();
        this.webLblautoRefresh = new WebLabel();
        this.setLayout(new CardLayout());
        this.m_jPanelMap.setFont(new Font("Arial", 0, 12));
        this.m_jPanelMap.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setFont(new Font("Arial", 0, 12));
        this.jPanel2.setLayout(new FlowLayout(0));
        this.m_jbtnReservations.setFont(new Font("Arial", 0, 12));
        this.m_jbtnReservations.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/date.png")));
        this.m_jbtnReservations.setText(AppLocal.getIntString("button.reservations"));
        this.m_jbtnReservations.setToolTipText("Open Reservations screen");
        this.m_jbtnReservations.setFocusPainted(false);
        this.m_jbtnReservations.setFocusable(false);
        this.m_jbtnReservations.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnReservations.setMaximumSize(new Dimension(133, 40));
        this.m_jbtnReservations.setMinimumSize(new Dimension(133, 40));
        this.m_jbtnReservations.setPreferredSize(new Dimension(133, 45));
        this.m_jbtnReservations.setRequestFocusEnabled(false);
        this.m_jbtnReservations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnReservationsActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnReservations);
        this.m_jbtnRefresh.setFont(new Font("Arial", 0, 12));
        this.m_jbtnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/reload.png")));
        this.m_jbtnRefresh.setText(AppLocal.getIntString("button.reloadticket"));
        this.m_jbtnRefresh.setToolTipText("Reload table information");
        this.m_jbtnRefresh.setFocusPainted(false);
        this.m_jbtnRefresh.setFocusable(false);
        this.m_jbtnRefresh.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnRefresh.setMaximumSize(new Dimension(100, 40));
        this.m_jbtnRefresh.setMinimumSize(new Dimension(100, 40));
        this.m_jbtnRefresh.setPreferredSize(new Dimension(100, 45));
        this.m_jbtnRefresh.setRequestFocusEnabled(false);
        this.m_jbtnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnRefreshActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnRefresh);
        this.m_jText.setFont(new Font("Arial", 0, 14));
        this.jPanel2.add(this.m_jText);
        this.m_jbtnLayout.setFont(new Font("Arial", 0, 12));
        this.m_jbtnLayout.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/movetable.png")));
        this.m_jbtnLayout.setText(AppLocal.getIntString("button.layout"));
        this.m_jbtnLayout.setToolTipText("");
        this.m_jbtnLayout.setFocusPainted(false);
        this.m_jbtnLayout.setFocusable(false);
        this.m_jbtnLayout.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnLayout.setMaximumSize(new Dimension(100, 40));
        this.m_jbtnLayout.setMinimumSize(new Dimension(100, 40));
        this.m_jbtnLayout.setPreferredSize(new Dimension(100, 45));
        this.m_jbtnLayout.setRequestFocusEnabled(false);
        this.m_jbtnLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnLayoutActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnLayout);
        this.m_jbtnSave.setFont(new Font("Arial", 0, 12));
        this.m_jbtnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/filesave.png")));
        this.m_jbtnSave.setText(AppLocal.getIntString("button.save"));
        this.m_jbtnSave.setToolTipText("");
        this.m_jbtnSave.setFocusPainted(false);
        this.m_jbtnSave.setFocusable(false);
        this.m_jbtnSave.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnSave.setMaximumSize(new Dimension(100, 40));
        this.m_jbtnSave.setMinimumSize(new Dimension(100, 40));
        this.m_jbtnSave.setPreferredSize(new Dimension(100, 45));
        this.m_jbtnSave.setRequestFocusEnabled(false);
        this.m_jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurantMap.this.m_jbtnSaveActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jbtnSave);
        this.jPanel1.add((Component)this.jPanel2, "Before");
        this.webLblautoRefresh.setBackground(new Color(255, 51, 51));
        this.webLblautoRefresh.setHorizontalAlignment(4);
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.webLblautoRefresh.setText(bundle.getString("label.autoRefreshTableMapTimerON"));
        this.webLblautoRefresh.setFont(new Font("Arial", 0, 14));
        this.jPanel1.add((Component)this.webLblautoRefresh, "Center");
        this.m_jPanelMap.add((Component)this.jPanel1, "North");
        this.add((Component)this.m_jPanelMap, "map");
    }

    private void m_jbtnRefreshActionPerformed(ActionEvent evt) {
        this.m_PlaceClipboard = null;
        this.customer = null;
        this.loadTickets();
        this.printState();
    }

    private void m_jbtnReservationsActionPerformed(ActionEvent evt) {
        this.showView("res");
        this.m_jreservations.activate();
    }

    private void m_jbtnLayoutActionPerformed(ActionEvent evt) {
        if (ResourceBundle.getBundle("pos_messages").getString("button.layout").equals(this.m_jbtnLayout.getText())) {
            this.actionEnabled = false;
            this.m_jbtnSave.setVisible(true);
            this.m_jbtnLayout.setText(ResourceBundle.getBundle("pos_messages").getString("button.disablelayout"));
            for (Place pl : this.m_aplaces) {
                if (!this.transBtns.booleanValue()) continue;
                pl.getButton().setOpaque(true);
                pl.getButton().setContentAreaFilled(true);
                pl.getButton().setBorderPainted(true);
            }
        } else {
            this.actionEnabled = true;
            this.m_jbtnSave.setVisible(false);
            this.m_jbtnLayout.setText(ResourceBundle.getBundle("pos_messages").getString("button.layout"));
            for (Place pl : this.m_aplaces) {
                if (!this.transBtns.booleanValue()) continue;
                pl.getButton().setOpaque(false);
                pl.getButton().setContentAreaFilled(false);
                pl.getButton().setBorderPainted(false);
            }
        }
    }

    private void m_jbtnSaveActionPerformed(ActionEvent evt) {
        for (Place pl : this.m_aplaces) {
            try {
                this.dlSystem.updatePlaces(pl.getX(), pl.getY(), pl.getId());
            }
            catch (BasicException ex) {
                Logger.getLogger(JTicketsBagRestaurantMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private final Place m_place;

        public MyActionListener(Place place) {
            this.m_place = place;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser();
            if (!JTicketsBagRestaurantMap.this.actionEnabled.booleanValue()) {
                this.m_place.setDiffX(0);
            } else {
                if (JTicketsBagRestaurantMap.this.m_PlaceClipboard == null) {
                    TicketInfo ticket = JTicketsBagRestaurantMap.this.getTicketInfo(this.m_place);
                    if (ticket == null) {
                        ticket = new TicketInfo();
                        ticket.setUser(JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().getUserInfo());
                        try {
                            JTicketsBagRestaurantMap.this.dlReceipts.insertSharedTicket(this.m_place.getId(), ticket, ticket.getPickupId());
                        }
                        catch (BasicException e) {
                            new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                        }
                        this.m_place.setPeople(true);
                        JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                    } else {
                        String m_lockState = null;
                        try {
                            m_lockState = JTicketsBagRestaurantMap.this.dlReceipts.getLockState(this.m_place.getId(), m_lockState);
                            if ("locked".equals(m_lockState)) {
                                int res;
                                JOptionPane.showMessageDialog(null, AppLocal.getIntString("message.sharedticketlock"));
                                if (JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().hasPermission("sales.Override") && (res = JOptionPane.showConfirmDialog(null, AppLocal.getIntString("message.sharedticketlockoverride"), AppLocal.getIntString("title.editor"), 0, 2)) == 0) {
                                    this.m_place.setPeople(true);
                                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                                    JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                                    JTicketsBagRestaurantMap.this.dlReceipts.lockSharedTicket(JTicketsBagRestaurantMap.this.m_PlaceCurrent.getId(), "locked");
                                }
                            } else {
                                String ticketuser;
                                String m_user = JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().getName();
                                if (m_user.equals(ticketuser = this.m_place.getWaiter()) || JTicketsBagRestaurantMap.this.m_App.getAppUserView().getUser().hasPermission("sales.Override")) {
                                    this.m_place.setPeople(true);
                                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                                    m_lockState = "locked";
                                    JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                                } else {
                                    JOptionPane.showMessageDialog(null, AppLocal.getIntString("message.sharedticket"), AppLocal.getIntString("title.editor"), 0);
                                }
                            }
                        }
                        catch (BasicException ex) {
                            Logger.getLogger(JTicketsBagRestaurantMap.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (JTicketsBagRestaurantMap.this.m_PlaceClipboard != null) {
                    TicketInfo ticketclip = JTicketsBagRestaurantMap.this.getTicketInfo(JTicketsBagRestaurantMap.this.m_PlaceClipboard);
                    if (ticketclip != null) {
                        TicketInfo ticket;
                        if (JTicketsBagRestaurantMap.this.m_PlaceClipboard == this.m_place) {
                            Place placeclip = JTicketsBagRestaurantMap.this.m_PlaceClipboard;
                            JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                            JTicketsBagRestaurantMap.this.customer = null;
                            JTicketsBagRestaurantMap.this.printState();
                            JTicketsBagRestaurantMap.this.setActivePlace(placeclip, ticketclip);
                        }
                        if (this.m_place.hasPeople()) {
                            ticket = JTicketsBagRestaurantMap.this.getTicketInfo(this.m_place);
                            if (ticket != null) {
                                if (JOptionPane.showConfirmDialog(JTicketsBagRestaurantMap.this, AppLocal.getIntString("message.mergetablequestion"), AppLocal.getIntString("message.mergetable"), 0) == 0) {
                                    try {
                                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                                        if (ticket.getCustomer() == null) {
                                            ticket.setCustomer(ticketclip.getCustomer());
                                        }
                                        ticketclip.getLines().stream().forEach(line -> ticket.addLine((TicketLineInfo)line));
                                        JTicketsBagRestaurantMap.this.dlReceipts.updateRSharedTicket(this.m_place.getId(), ticket, ticket.getPickupId());
                                        JTicketsBagRestaurantMap.this.dlReceipts.deleteSharedTicket(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getId());
                                    }
                                    catch (BasicException e) {
                                        new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                                    }
                                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                                    JTicketsBagRestaurantMap.this.customer = null;
                                    JTicketsBagRestaurantMap.this.restDB.clearCustomerNameInTable(JTicketsBagRestaurantMap.this.restDB.getTableDetails(ticketclip.getId()));
                                    JTicketsBagRestaurantMap.this.restDB.clearWaiterNameInTable(JTicketsBagRestaurantMap.this.restDB.getTableDetails(ticketclip.getId()));
                                    JTicketsBagRestaurantMap.this.restDB.clearTableMovedFlag(JTicketsBagRestaurantMap.this.restDB.getTableDetails(ticketclip.getId()));
                                    JTicketsBagRestaurantMap.this.restDB.clearTicketIdInTable(JTicketsBagRestaurantMap.this.restDB.getTableDetails(ticketclip.getId()));
                                    JTicketsBagRestaurantMap.this.printState();
                                    JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticket);
                                } else {
                                    Place placeclip = JTicketsBagRestaurantMap.this.m_PlaceClipboard;
                                    JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                                    JTicketsBagRestaurantMap.this.customer = null;
                                    JTicketsBagRestaurantMap.this.printState();
                                    JTicketsBagRestaurantMap.this.setActivePlace(placeclip, ticketclip);
                                }
                            } else {
                                new MessageInf(-33554432, AppLocal.getIntString("message.tableempty")).show(JTicketsBagRestaurantMap.this);
                                this.m_place.setPeople(false);
                            }
                        } else {
                            ticket = JTicketsBagRestaurantMap.this.getTicketInfo(this.m_place);
                            if (ticket == null) {
                                try {
                                    JTicketsBagRestaurantMap.this.dlReceipts.insertRSharedTicket(this.m_place.getId(), ticketclip, ticketclip.getPickupId());
                                    this.m_place.setPeople(true);
                                    JTicketsBagRestaurantMap.this.dlReceipts.deleteSharedTicket(JTicketsBagRestaurantMap.this.m_PlaceClipboard.getId());
                                    JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                                }
                                catch (BasicException e) {
                                    new MessageInf(e).show(JTicketsBagRestaurantMap.this);
                                }
                                JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                                JTicketsBagRestaurantMap.this.customer = null;
                                JTicketsBagRestaurantMap.this.printState();
                                JTicketsBagRestaurantMap.this.setActivePlace(this.m_place, ticketclip);
                            } else {
                                new MessageInf(-33554432, AppLocal.getIntString("message.tablefull")).show(JTicketsBagRestaurantMap.this);
                                JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(true);
                                JTicketsBagRestaurantMap.this.printState();
                            }
                        }
                    } else {
                        new MessageInf(-33554432, AppLocal.getIntString("message.tableempty")).show(JTicketsBagRestaurantMap.this);
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard.setPeople(false);
                        JTicketsBagRestaurantMap.this.m_PlaceClipboard = null;
                        JTicketsBagRestaurantMap.this.customer = null;
                        JTicketsBagRestaurantMap.this.printState();
                    }
                }
            }
        }
    }

    class tableMapRefresh
    implements ActionListener {
        tableMapRefresh() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTicketsBagRestaurantMap.this.loadTickets();
            JTicketsBagRestaurantMap.this.printState();
        }
    }

    private static class ServerCurrent {
    }
}

