/*
 * Decompiled with CFR 0.152.
 */
package com.unicenta.pos.transfer;

import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.progressbar.WebProgressBar;
import com.alee.laf.text.WebPasswordField;
import com.alee.laf.text.WebTextField;
import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.BatchSentenceResource;
import com.openbravo.data.loader.Session;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.AppViewConnection;
import com.openbravo.pos.forms.DriverWrapper;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.util.AltEncrypter;
import com.openbravo.pos.util.DirectoryEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;

public final class Transfer
extends JPanel
implements JPanelView {
    private DirtyManager dirty = new DirtyManager();
    private AppConfig config;
    private AppProperties m_props;
    private List<PanelConfig> m_panelconfig;
    private Connection con_source;
    private Connection con_target;
    private String sDB_source;
    private String sDB_target;
    private Session session_source;
    private Session session_target;
    private ResultSet rs;
    private Statement stmt_source;
    private Statement stmt_target;
    private PreparedStatement pstmt;
    private String SQL;
    private String source_version;
    private String ticketsnum;
    private String ticketsnumRefund;
    private String ticketsnumPayment;
    private String targetCreate = "";
    private String targetFKadd = "";
    private String targetFKdrop = "";
    ArrayList<String> stringList = new ArrayList();
    public String strOut = "";
    private WebComboBox cbSource;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JButton jbtnDbDriverLib;
    private JButton jbtnExit;
    private JButton jbtnTest;
    private JButton jbtnTransfer;
    private JLabel jlblDBSize;
    private JLabel jlblSource;
    private JLabel jlblVersion;
    private WebTextField jtxtDbDriver;
    private WebTextField jtxtDbDriverLib;
    private WebTextField jtxtDbName;
    private WebTextField jtxtDbParams;
    private WebTextField jtxtDbServerPort;
    private WebTextField jtxtDbType;
    private WebPasswordField txtDbPass;
    private WebTextField txtDbUser;
    private JTextArea txtOut;
    private WebProgressBar webPBar;

    public Transfer(AppView oApp) {
        this(oApp.getProperties());
    }

    public Transfer(AppProperties props) {
        this.initComponents();
        this.config = new AppConfig(props.getConfigFile());
        this.m_props = props;
        this.m_panelconfig = new ArrayList<PanelConfig>();
        this.config.load();
        this.m_panelconfig.stream().forEach(c -> c.loadProperties(this.config));
        this.jtxtDbDriverLib.getDocument().addDocumentListener(this.dirty);
        this.jtxtDbDriver.getDocument().addDocumentListener(this.dirty);
        this.jtxtDbType.getDocument().addDocumentListener(this.dirty);
        this.txtDbPass.getDocument().addDocumentListener(this.dirty);
        this.txtDbUser.getDocument().addDocumentListener(this.dirty);
        this.txtOut.getDocument().addDocumentListener(this.dirty);
        this.jbtnDbDriverLib.addActionListener(new DirectoryEvent((JTextComponent)this.jtxtDbDriverLib));
        this.cbSource.addActionListener((ActionListener)this.dirty);
        this.cbSource.addItem((Object)"MySQL");
        this.cbSource.addItem((Object)"PostgreSQL");
        this.cbSource.addItem((Object)"Derby");
        this.stringList.add("Transfer Ready...\n");
        this.txtOut.setText(this.stringList.get(0));
        this.webPBar.setIndeterminate(true);
        this.webPBar.setStringPainted(true);
        this.webPBar.setString("Waiting...");
        this.webPBar.setVisible(false);
        this.jbtnTransfer.setEnabled(false);
        this.jbtnExit.setVisible(false);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.Transfer");
    }

    public Boolean getSource() {
        String db_url2 = this.jtxtDbType.getText() + this.jtxtDbServerPort.getText() + this.jtxtDbName.getText() + this.jtxtDbParams.getText();
        String db_user2 = this.txtDbUser.getText();
        char[] pass = this.txtDbPass.getPassword();
        String db_password2 = new String(pass);
        Properties connectionProps = new Properties();
        connectionProps.put("user", db_user2);
        connectionProps.put("password", db_password2);
        try {
            Class.forName(this.jtxtDbDriver.getText());
            URLClassLoader cloader = new URLClassLoader(new URL[]{new File(this.jtxtDbDriverLib.getText()).toURI().toURL()});
            DriverManager.registerDriver(new DriverWrapper((Driver)Class.forName(this.jtxtDbDriver.getText(), true, cloader).newInstance()));
            this.con_source = DriverManager.getConnection(db_url2, db_user2, db_password2);
            this.session_source = new Session(db_url2, db_user2, db_password2);
            this.sDB_source = this.con_source.getMetaData().getDatabaseProductName();
            this.txtOut.append("Connected to Source OK\n");
            this.jbtnTransfer.setEnabled(true);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException | SQLException e) {
            JMessageDialog.showMessage(this, new MessageInf(-16777216, AppLocal.getIntString("database.UnableToConnect"), e));
            return false;
        }
    }

    public Boolean createTargetDB() {
        block6: {
            this.targetCreate = "/com/openbravo/pos/scripts/" + this.sDB_target + "-create-transfer.sql";
            this.targetFKadd = "/com/openbravo/pos/scripts/MySQL-FKeys.sql";
            this.targetFKdrop = "/com/openbravo/pos/scripts/MySQL-dropFKeys.sql";
            if ("".equals(this.targetCreate)) {
                return false;
            }
            try {
                BatchSentenceResource bsentence = new BatchSentenceResource(this.session_target, this.targetCreate);
                bsentence = new BatchSentenceResource(this.session_target, this.targetFKdrop);
                bsentence.putParameter("APP_ID", Matcher.quoteReplacement("unicentaopos"));
                bsentence.putParameter("APP_NAME", Matcher.quoteReplacement("uniCenta oPOS"));
                bsentence.putParameter("APP_VERSION", Matcher.quoteReplacement("4.5"));
                List l = bsentence.list();
                if (l.size() > 0) {
                    JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("transfer.warning"), l.toArray(new Throwable[l.size()])));
                    break block6;
                }
                this.txtOut.append("Connected to Target OK\n");
                this.txtOut.revalidate();
                this.txtOut.repaint();
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-16777216, AppLocal.getIntString("transfer.warningnodefault"), e));
                this.session_source.close();
            }
        }
        return true;
    }

    public Boolean FKeys() {
        block6: {
            if ("".equals(this.targetFKadd)) {
                return false;
            }
            try {
                this.txtOut.append("Adding Foreign Keys\n");
                this.webPBar.setString("Adding Keys...");
                this.webPBar.setBgBottom(Color.MAGENTA);
                BatchSentenceResource bsentence = new BatchSentenceResource(this.session_target, this.targetFKadd);
                List l = bsentence.list();
                if (l.size() > 0) {
                    JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("transfer.warning"), l.toArray(new Throwable[l.size()])));
                    this.txtOut.append("Foreign Key error\n");
                    break block6;
                }
                this.txtOut.append("Foreign Keys completed\n");
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-16777216, AppLocal.getIntString("database.ScriptNotFound"), e));
                this.session_source.close();
            }
        }
        this.txtOut.revalidate();
        this.txtOut.repaint();
        return true;
    }

    @Override
    public void activate() throws BasicException {
        String db_url = this.m_props.getProperty("db.URL");
        String db_schema = this.m_props.getProperty("db.schema");
        String db_options = this.m_props.getProperty("db.options");
        String db_user = this.m_props.getProperty("db.user");
        String db_password = this.m_props.getProperty("db.password");
        String url = db_url + db_schema + db_options;
        if (db_user != null && db_password != null && db_password.startsWith("crypt:")) {
            AltEncrypter cypher = new AltEncrypter("cypherkey" + db_user);
            db_password = cypher.decrypt(db_password.substring(6));
        }
        try {
            this.session_target = AppViewConnection.createSession(this.m_props);
            this.con_target = DriverManager.getConnection(url, db_user, db_password);
            this.sDB_target = this.con_target.getMetaData().getDatabaseProductName();
            this.jlblSource.setText(this.con_target.getCatalog());
        }
        catch (BasicException | SQLException e) {
            JMessageDialog.showMessage(this, new MessageInf(-16777216, AppLocal.getIntString("database.UnableToConnect"), e));
        }
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    public void clearData() throws SQLException {
        Statement stmt = null;
        try {
            this.con_target.setAutoCommit(false);
            stmt = this.con_target.createStatement();
            stmt.addBatch("DELETE FROM attributesetinstance;");
            stmt.addBatch("DELETE FROM attributeinstance;");
            stmt.addBatch("DELETE FROM attributevalue");
            stmt.addBatch("DELETE FROM attributeuse");
            stmt.addBatch("DELETE FROM attributeset");
            stmt.addBatch("DELETE FROM attribute");
            stmt.addBatch("DELETE FROM people;");
            stmt.addBatch("DELETE FROM categories;");
            stmt.addBatch("DELETE FROM taxcategories;");
            stmt.addBatch("DELETE FROM taxcustcategories;");
            stmt.addBatch("DELETE FROM taxes;");
            stmt.addBatch("DELETE FROM locations;");
            stmt.addBatch("DELETE FROM floors;");
            stmt.addBatch("DELETE FROM places;");
            stmt.addBatch("DELETE FROM shifts;");
            stmt.addBatch("DELETE FROM breaks;");
            stmt.addBatch("DELETE FROM shift_breaks;");
            stmt.addBatch("DELETE FROM closedcash;");
            stmt.addBatch("DELETE FROM csvimport;");
            stmt.addBatch("DELETE FROM customers;");
            stmt.addBatch("DELETE FROM draweropened;");
            stmt.addBatch("DELETE FROM leaves;");
            stmt.addBatch("DELETE FROM lineremoved;");
            stmt.addBatch("DELETE FROM payments;");
            stmt.addBatch("DELETE FROM products_cat;");
            stmt.addBatch("DELETE FROM products_com;");
            stmt.addBatch("DELETE FROM products;");
            stmt.addBatch("DELETE FROM receipts;");
            stmt.addBatch("DELETE FROM roles WHERE NOT ID = '0';");
            stmt.addBatch("DELETE FROM stockcurrent;");
            stmt.addBatch("DELETE FROM stockdiary;");
            stmt.addBatch("DELETE FROM stocklevel;");
            stmt.addBatch("DELETE FROM suppliers;");
            stmt.addBatch("DELETE FROM uom;");
            stmt.addBatch("DELETE FROM vouchers;");
            int[] updateCounts = stmt.executeBatch();
            this.con_target.commit();
        }
        catch (BatchUpdateException batchUpdateException) {
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.con_target.setAutoCommit(true);
        }
    }

    public void doTransfer() {
        this.webPBar.setString("Starting...");
        this.webPBar.setVisible(true);
        String Dbtname = "";
        if (this.getSource().booleanValue()) {
            this.txtOut.setVisible(true);
            this.txtOut.append("Transfer Started...\n");
            if (this.createTargetDB().booleanValue()) {
                this.jbtnTransfer.setEnabled(false);
                try {
                    this.stmt_source = this.con_source.createStatement();
                    this.stmt_target = this.con_target.createStatement();
                    this.clearData();
                    this.con_target.setAutoCommit(false);
                    this.webPBar.setString("Running...");
                    Dbtname = "attribute";
                    ResultSet rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attribute\n");
                    this.SQL = "SELECT ID, NAME FROM attribute";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attribute (ID, NAME) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "attributevalue";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attributevalue\n");
                    this.SQL = "SELECT ID, ATTRIBUTE_ID, VALUE FROM attributevalue";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attributevalue (ID, ATTRIBUTE_ID, VALUE) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("ATTRIBUTE_ID"));
                        this.pstmt.setString(3, rs.getString("VALUE"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "attributeinstance";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attributeinstance\n");
                    this.SQL = "SELECT ID, ATTRIBUTESETINSTANCE_ID, ATTRIBUTE_ID, VALUE FROM attributeinstance";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attributeinstance (ID, ATTRIBUTESETINSTANCE_ID, ATTRIBUTE_ID, VALUE) VALUES (?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("ATTRIBUTESETINSTANCE_ID"));
                        this.pstmt.setString(3, rs.getString("ATTRIBUTE_ID"));
                        this.pstmt.setString(4, rs.getString("VALUE"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "attributesetinstance";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attributesetinstance\n");
                    this.SQL = "SELECT ID, ATTRIBUTESET_ID, DESCRIPTION FROM attributesetinstance";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attributesetinstance (ID, ATTRIBUTESET_ID, DESCRIPTION) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("ATTRIBUTESET_ID"));
                        this.pstmt.setString(3, rs.getString("DESCRIPTION"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "attributeuse";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attributeuse\n");
                    this.SQL = "SELECT ID, ATTRIBUTESET_ID, ATTRIBUTE_ID FROM attributeuse";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attributeuse(ID, ATTRIBUTESET_ID, ATTRIBUTE_ID) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("ATTRIBUTESET_ID"));
                        this.pstmt.setString(3, rs.getString("ATTRIBUTE_ID"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "attributeset";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Attributeset\n");
                    this.SQL = "SELECT ID, NAME FROM attributeset";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO attributeset (ID, NAME) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.executeUpdate();
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "breaks";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Breaks\n");
                        this.SQL = "SELECT * FROM breaks";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO breaks(ID, NAME, VISIBLE, NOTES) VALUES (?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setString(3, rs.getString("VISIBLE"));
                            this.pstmt.setBoolean(4, rs.getBoolean("NOTES"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Breaks... skipped\n");
                    }
                    Dbtname = "categories";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Categories\n");
                    this.SQL = "SELECT * FROM categories";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 6) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO categories(ID, NAME, PARENTID, IMAGE, TEXTTIP, CATSHOWNAME) VALUES (?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setString(3, rs.getString("PARENTID"));
                            this.pstmt.setBytes(4, rs.getBytes("IMAGE"));
                            this.pstmt.setString(5, rs.getString("TEXTTIP"));
                            this.pstmt.setString(6, rs.getString("CATSHOWNAME"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO categories(ID, NAME, PARENTID, IMAGE) VALUES (?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setString(3, rs.getString("PARENTID"));
                            this.pstmt.setBytes(4, rs.getBytes("IMAGE"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "closedcash";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("ClosedCash\n");
                    this.SQL = "DELETE FROM closedcash";
                    this.pstmt = this.con_target.prepareStatement(this.SQL);
                    this.pstmt.executeUpdate();
                    this.SQL = "SELECT * FROM closedcash";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 6) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO closedcash(MONEY, HOST, HOSTSEQUENCE, DATESTART, DATEEND, NOSALES) VALUES (?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("MONEY"));
                            this.pstmt.setString(2, rs.getString("HOST"));
                            this.pstmt.setInt(3, rs.getInt("HOSTSEQUENCE"));
                            this.pstmt.setTimestamp(4, rs.getTimestamp("DATESTART"));
                            this.pstmt.setTimestamp(5, rs.getTimestamp("DATEEND"));
                            this.pstmt.setInt(6, rs.getInt("NOSALES"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO closedcash(MONEY, HOST, HOSTSEQUENCE, DATESTART, DATEEND) VALUES (?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("MONEY"));
                            this.pstmt.setString(2, rs.getString("HOST"));
                            this.pstmt.setInt(3, rs.getInt("HOSTSEQUENCE"));
                            this.pstmt.setTimestamp(4, rs.getTimestamp("DATESTART"));
                            this.pstmt.setTimestamp(5, rs.getTimestamp("DATEEND"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "customers";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Customers\n");
                    this.SQL = "SELECT * FROM customers";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 27) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO customers(ID, SEARCHKEY, TAXID, NAME, TAXCATEGORY, CARD, MAXDEBT,ADDRESS, ADDRESS2, POSTAL, CITY, REGION, COUNTRY, FIRSTNAME, LASTNAME,EMAIL, PHONE, PHONE2, FAX, NOTES, VISIBLE, CURDATE, CURDEBT, IMAGE, ISVIP, DISCOUNT, MEMODATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("SEARCHKEY"));
                            this.pstmt.setString(3, rs.getString("TAXID"));
                            this.pstmt.setString(4, rs.getString("NAME"));
                            this.pstmt.setString(5, rs.getString("TAXCATEGORY"));
                            this.pstmt.setString(6, rs.getString("CARD"));
                            this.pstmt.setDouble(7, rs.getDouble("MAXDEBT"));
                            this.pstmt.setString(8, rs.getString("ADDRESS"));
                            this.pstmt.setString(9, rs.getString("ADDRESS2"));
                            this.pstmt.setString(10, rs.getString("POSTAL"));
                            this.pstmt.setString(11, rs.getString("CITY"));
                            this.pstmt.setString(12, rs.getString("REGION"));
                            this.pstmt.setString(13, rs.getString("COUNTRY"));
                            this.pstmt.setString(14, rs.getString("FIRSTNAME"));
                            this.pstmt.setString(15, rs.getString("LASTNAME"));
                            this.pstmt.setString(16, rs.getString("EMAIL"));
                            this.pstmt.setString(17, rs.getString("PHONE"));
                            this.pstmt.setString(18, rs.getString("PHONE2"));
                            this.pstmt.setString(19, rs.getString("FAX"));
                            this.pstmt.setString(20, rs.getString("NOTES"));
                            this.pstmt.setBoolean(21, rs.getBoolean("VISIBLE"));
                            this.pstmt.setTimestamp(22, rs.getTimestamp("CURDATE"));
                            this.pstmt.setDouble(23, rs.getDouble("CURDEBT"));
                            this.pstmt.setBytes(24, rs.getBytes("IMAGE"));
                            this.pstmt.setBoolean(25, rs.getBoolean("ISVIP"));
                            this.pstmt.setDouble(26, rs.getDouble("DISCOUNT"));
                            this.pstmt.setTimestamp(27, rs.getTimestamp("MEMODATE"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO customers(ID, SEARCHKEY, TAXID, NAME, TAXCATEGORY, CARD, MAXDEBT,ADDRESS, ADDRESS2, POSTAL, CITY, REGION, COUNTRY, FIRSTNAME, LASTNAME, EMAIL, PHONE, PHONE2, FAX, NOTES, VISIBLE, CURDATE, CURDEBT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("SEARCHKEY"));
                            this.pstmt.setString(3, rs.getString("TAXID"));
                            this.pstmt.setString(4, rs.getString("NAME"));
                            this.pstmt.setString(5, rs.getString("TAXCATEGORY"));
                            this.pstmt.setString(6, rs.getString("CARD"));
                            this.pstmt.setDouble(7, rs.getDouble("MAXDEBT"));
                            this.pstmt.setString(8, rs.getString("ADDRESS"));
                            this.pstmt.setString(9, rs.getString("ADDRESS2"));
                            this.pstmt.setString(10, rs.getString("POSTAL"));
                            this.pstmt.setString(11, rs.getString("CITY"));
                            this.pstmt.setString(12, rs.getString("REGION"));
                            this.pstmt.setString(13, rs.getString("COUNTRY"));
                            this.pstmt.setString(14, rs.getString("FIRSTNAME"));
                            this.pstmt.setString(15, rs.getString("LASTNAME"));
                            this.pstmt.setString(16, rs.getString("EMAIL"));
                            this.pstmt.setString(17, rs.getString("PHONE"));
                            this.pstmt.setString(18, rs.getString("PHONE2"));
                            this.pstmt.setString(19, rs.getString("FAX"));
                            this.pstmt.setString(20, rs.getString("NOTES"));
                            this.pstmt.setBoolean(21, rs.getBoolean("VISIBLE"));
                            this.pstmt.setTimestamp(22, rs.getTimestamp("CURDATE"));
                            this.pstmt.setDouble(23, rs.getDouble("CURDEBT"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "draweropened";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("DrawerOpened\n");
                        this.SQL = "SELECT * FROM draweropened";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO draweropened(OPENDATE, NAME, TICKETID) VALUES (?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("OPENDATE"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setString(3, rs.getString("TICKETID"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "floors";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Floors\n");
                    this.SQL = "SELECT * FROM floors";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO floors (ID, NAME, IMAGE) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.setBytes(3, rs.getBytes("IMAGE"));
                        this.pstmt.executeUpdate();
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "leaves";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Leaves\n");
                        this.SQL = "SELECT * FROM leaves";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO leaves (ID, PPLID, NAME, STARTDATE, ENDDATE, NOTES) VALUES (?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("PPLID"));
                            this.pstmt.setString(3, rs.getString("NAME"));
                            this.pstmt.setTimestamp(4, rs.getTimestamp("STARTDATE"));
                            this.pstmt.setTimestamp(5, rs.getTimestamp("ENDDATE"));
                            this.pstmt.setString(6, rs.getString("NOTES"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Leaves... skipped\n");
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "lineremoved";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("LineRemoved\n");
                        this.SQL = "SELECT * FROM lineremoved";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO lineremoved (REMOVEDDATE, NAME, TICKETID, PRODUCTID, PRODUCTNAME, UNITS) VALUES (?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setTimestamp(1, rs.getTimestamp("REMOVEDDATE"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setString(3, rs.getString("TICKETID"));
                            this.pstmt.setString(4, rs.getString("PRODUCTID"));
                            this.pstmt.setString(5, rs.getString("PRODUCTNAME"));
                            this.pstmt.setDouble(6, rs.getDouble("UNITS"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Line Removed... skipped\n");
                    }
                    Dbtname = "locations";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Locations\n");
                    this.SQL = "SELECT * FROM locations";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO locations(ID, NAME, ADDRESS) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.setString(3, rs.getString("ADDRESS"));
                        this.pstmt.executeUpdate();
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "moorers";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Moorers\n");
                        this.SQL = "SELECT * FROM moorers";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO moorers(VESSELNAME, SIZE, DAYS, POWER) VALUES (?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("VESSELNAME"));
                            this.pstmt.setInt(2, rs.getInt("SIZE"));
                            this.pstmt.setInt(3, rs.getInt("DAYS"));
                            this.pstmt.setBoolean(4, rs.getBoolean("POWER"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Moorers... skipped\n");
                    }
                    Dbtname = "payments";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Payments\n");
                    this.SQL = "SELECT * FROM payments";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO payments(ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG, NOTES, TENDERED) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("RECEIPT"));
                            this.pstmt.setString(3, rs.getString("PAYMENT"));
                            this.pstmt.setDouble(4, rs.getDouble("TOTAL"));
                            this.pstmt.setString(5, rs.getString("TRANSID"));
                            this.pstmt.setBytes(6, rs.getBytes("RETURNMSG"));
                            this.pstmt.setString(7, rs.getString("NOTES"));
                            this.pstmt.setDouble(8, rs.getDouble("TENDERED"));
                            this.pstmt.executeUpdate();
                        }
                        this.SQL = "UPDATE payments SET payment='ccard' WHERE payment='magcard'";
                        this.pstmt.execute(this.SQL);
                        this.SQL = "UPDATE payments SET payment='ccardrefund' WHERE payment='magcardrefund'";
                        this.pstmt.execute(this.SQL);
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO payments(ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG) VALUES (?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("RECEIPT"));
                            this.pstmt.setString(3, rs.getString("PAYMENT"));
                            this.pstmt.setDouble(4, rs.getDouble("TOTAL"));
                            this.pstmt.setString(5, rs.getString("TRANSID"));
                            this.pstmt.setBytes(6, rs.getBytes("RETURNMSG"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "people";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("People\n");
                    this.SQL = "SELECT * FROM people";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO people(ID, NAME, APPPASSWORD, CARD, ROLE, VISIBLE, IMAGE) VALUES (?, ?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.setString(3, rs.getString("APPPASSWORD"));
                        this.pstmt.setString(4, rs.getString("CARD"));
                        this.pstmt.setString(5, rs.getString("ROLE"));
                        this.pstmt.setBoolean(6, rs.getBoolean("VISIBLE"));
                        this.pstmt.setBytes(7, rs.getBytes("IMAGE"));
                        this.pstmt.executeUpdate();
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "pickup_number";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Pickup Number\n");
                        this.SQL = "SELECT * FROM pickup_number";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO pickup_number(ID) VALUES (?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Pickup Number... skipped\n");
                    }
                    Dbtname = "places";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Places\n");
                    this.SQL = "SELECT * FROM places";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 9) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO places (ID, NAME, X, Y, FLOOR, CUSTOMER, WAITER, TICKETID, TABLEMOVED) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setInt(3, rs.getInt("X"));
                            this.pstmt.setInt(4, rs.getInt("Y"));
                            this.pstmt.setString(5, rs.getString("FLOOR"));
                            this.pstmt.setString(6, rs.getString("CUSTOMER"));
                            this.pstmt.setString(7, rs.getString("WAITER"));
                            this.pstmt.setString(8, rs.getString("TICKETID"));
                            this.pstmt.setBoolean(9, rs.getBoolean("TABLEMOVED"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO places (ID, NAME, X, Y, FLOOR) VALUES (?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("NAME"));
                            this.pstmt.setInt(3, rs.getInt("X"));
                            this.pstmt.setInt(4, rs.getInt("Y"));
                            this.pstmt.setString(5, rs.getString("FLOOR"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "products";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Products\n");
                    this.SQL = "SELECT * FROM products";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    switch (rs.getMetaData().getColumnCount()) {
                        case 30: {
                            while (rs.next()) {
                                this.SQL = "INSERT INTO products(ID, REFERENCE, CODE, CODETYPE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, ATTRIBUTESET_ID, STOCKCOST, STOCKVOLUME, IMAGE, ISCOM, ISSCALE, ISCONSTANT, PRINTKB, SENDSTATUS, ISSERVICE, ATTRIBUTES, DISPLAY, ISVPRICE, ISVERPATRIB, TEXTTIP, WARRANTY, STOCKUNITS, PRINTTO, SUPPLIER, UOM, MEMODATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?)";
                                this.pstmt = this.con_target.prepareStatement(this.SQL);
                                this.pstmt.setString(1, rs.getString("ID"));
                                this.pstmt.setString(2, rs.getString("REFERENCE"));
                                this.pstmt.setString(3, rs.getString("CODE"));
                                this.pstmt.setString(4, rs.getString("CODETYPE"));
                                this.pstmt.setString(5, rs.getString("NAME"));
                                this.pstmt.setDouble(6, rs.getDouble("PRICEBUY"));
                                this.pstmt.setDouble(7, rs.getDouble("PRICESELL"));
                                this.pstmt.setString(8, rs.getString("CATEGORY"));
                                this.pstmt.setString(9, rs.getString("TAXCAT"));
                                this.pstmt.setString(10, rs.getString("ATTRIBUTESET_ID"));
                                this.pstmt.setDouble(11, rs.getDouble("STOCKCOST"));
                                this.pstmt.setDouble(12, rs.getDouble("STOCKVOLUME"));
                                this.pstmt.setBytes(13, rs.getBytes("IMAGE"));
                                this.pstmt.setBoolean(14, rs.getBoolean("ISCOM"));
                                this.pstmt.setBoolean(15, rs.getBoolean("ISSCALE"));
                                this.pstmt.setBoolean(16, rs.getBoolean("ISCONSTANT"));
                                this.pstmt.setBoolean(17, rs.getBoolean("PRINTKB"));
                                this.pstmt.setBoolean(18, rs.getBoolean("SENDSTATUS"));
                                this.pstmt.setBoolean(19, rs.getBoolean("ISSERVICE"));
                                this.pstmt.setBytes(20, rs.getBytes("ATTRIBUTES"));
                                this.pstmt.setString(21, rs.getString("DISPLAY"));
                                this.pstmt.setBoolean(22, rs.getBoolean("ISVPRICE"));
                                this.pstmt.setBoolean(23, rs.getBoolean("ISVERPATRIB"));
                                this.pstmt.setString(24, rs.getString("TEXTTIP"));
                                this.pstmt.setBoolean(25, rs.getBoolean("WARRANTY"));
                                this.pstmt.setDouble(26, rs.getDouble("STOCKUNITS"));
                                this.pstmt.setString(27, rs.getString("PRINTTO"));
                                this.pstmt.setString(28, rs.getString("SUPPLIER"));
                                this.pstmt.setString(29, rs.getString("UOM"));
                                this.pstmt.setTimestamp(30, rs.getTimestamp("MEMODATE"));
                                this.pstmt.executeUpdate();
                            }
                            break;
                        }
                        case 29: {
                            while (rs.next()) {
                                this.SQL = "INSERT INTO products(ID, REFERENCE, CODE, CODETYPE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, ATTRIBUTESET_ID, STOCKCOST, STOCKVOLUME, IMAGE, ISCOM, ISSCALE, ISCONSTANT, PRINTKB, SENDSTATUS, ISSERVICE, ATTRIBUTES, DISPLAY, ISVPRICE, ISVERPATRIB, TEXTTIP, WARRANTY, STOCKUNITS, PRINTTO, SUPPLIER, UOM) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                                this.pstmt = this.con_target.prepareStatement(this.SQL);
                                this.pstmt.setString(1, rs.getString("ID"));
                                this.pstmt.setString(2, rs.getString("REFERENCE"));
                                this.pstmt.setString(3, rs.getString("CODE"));
                                this.pstmt.setString(4, rs.getString("CODETYPE"));
                                this.pstmt.setString(5, rs.getString("NAME"));
                                this.pstmt.setDouble(6, rs.getDouble("PRICEBUY"));
                                this.pstmt.setDouble(7, rs.getDouble("PRICESELL"));
                                this.pstmt.setString(8, rs.getString("CATEGORY"));
                                this.pstmt.setString(9, rs.getString("TAXCAT"));
                                this.pstmt.setString(10, rs.getString("ATTRIBUTESET_ID"));
                                this.pstmt.setDouble(11, rs.getDouble("STOCKCOST"));
                                this.pstmt.setDouble(12, rs.getDouble("STOCKVOLUME"));
                                this.pstmt.setBytes(13, rs.getBytes("IMAGE"));
                                this.pstmt.setBoolean(14, rs.getBoolean("ISCOM"));
                                this.pstmt.setBoolean(15, rs.getBoolean("ISSCALE"));
                                this.pstmt.setBoolean(16, rs.getBoolean("ISCONSTANT"));
                                this.pstmt.setBoolean(17, rs.getBoolean("PRINTKB"));
                                this.pstmt.setBoolean(18, rs.getBoolean("SENDSTATUS"));
                                this.pstmt.setBoolean(19, rs.getBoolean("ISSERVICE"));
                                this.pstmt.setBytes(20, rs.getBytes("ATTRIBUTES"));
                                this.pstmt.setString(21, rs.getString("DISPLAY"));
                                this.pstmt.setBoolean(22, rs.getBoolean("ISVPRICE"));
                                this.pstmt.setBoolean(23, rs.getBoolean("ISVERPATRIB"));
                                this.pstmt.setString(24, rs.getString("TEXTTIP"));
                                this.pstmt.setBoolean(25, rs.getBoolean("WARRANTY"));
                                this.pstmt.setDouble(26, rs.getDouble("STOCKUNITS"));
                                this.pstmt.setString(27, rs.getString("PRINTTO"));
                                this.pstmt.setString(28, rs.getString("SUPPLIER"));
                                this.pstmt.setString(29, rs.getString("UOM"));
                                this.pstmt.executeUpdate();
                            }
                            break;
                        }
                        default: {
                            while (rs.next()) {
                                this.SQL = "INSERT INTO products(ID, REFERENCE, CODE, CODETYPE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, ATTRIBUTESET_ID, STOCKCOST, STOCKVOLUME, IMAGE, ISCOM, ISSCALE, ATTRIBUTES, DISPLAY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                                this.pstmt = this.con_target.prepareStatement(this.SQL);
                                this.pstmt.setString(1, rs.getString("ID"));
                                this.pstmt.setString(2, rs.getString("REFERENCE"));
                                this.pstmt.setString(3, rs.getString("CODE"));
                                this.pstmt.setString(4, rs.getString("CODETYPE"));
                                this.pstmt.setString(5, rs.getString("NAME"));
                                this.pstmt.setDouble(6, rs.getDouble("PRICEBUY"));
                                this.pstmt.setDouble(7, rs.getDouble("PRICESELL"));
                                this.pstmt.setString(8, rs.getString("CATEGORY"));
                                this.pstmt.setString(9, rs.getString("TAXCAT"));
                                this.pstmt.setString(10, rs.getString("ATTRIBUTESET_ID"));
                                this.pstmt.setDouble(11, rs.getDouble("STOCKCOST"));
                                this.pstmt.setDouble(12, rs.getDouble("STOCKVOLUME"));
                                this.pstmt.setBytes(13, rs.getBytes("IMAGE"));
                                this.pstmt.setBoolean(14, rs.getBoolean("ISCOM"));
                                this.pstmt.setBoolean(15, rs.getBoolean("ISSCALE"));
                                this.pstmt.setBytes(16, rs.getBytes("ATTRIBUTES"));
                                this.pstmt.setString(17, "<html><center>" + rs.getString("NAME"));
                                this.pstmt.executeUpdate();
                            }
                            break block2;
                        }
                    }
                    Dbtname = "products_cat";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Products_Cat\n");
                    this.SQL = "SELECT * FROM products_cat";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO products_cat(PRODUCT, CATORDER) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("PRODUCT"));
                        this.pstmt.setInt(2, rs.getInt("CATORDER"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "products_com";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Products_Com\n");
                    this.SQL = "SELECT * FROM products_com";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO products_com(ID, PRODUCT, PRODUCT2) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("PRODUCT"));
                        this.pstmt.setString(3, rs.getString("PRODUCT2"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "receipts";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Receipts\n");
                    this.SQL = "SELECT * FROM receipts";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 5) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO receipts(ID, MONEY, DATENEW, ATTRIBUTES, PERSON) VALUES (?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("MONEY"));
                            this.pstmt.setTimestamp(3, rs.getTimestamp("DATENEW"));
                            this.pstmt.setBytes(4, rs.getBytes("ATTRIBUTES"));
                            this.pstmt.setString(5, rs.getString("PERSON"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO receipts(ID, MONEY, DATENEW, ATTRIBUTES) VALUES (?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("MONEY"));
                            this.pstmt.setTimestamp(3, rs.getTimestamp("DATENEW"));
                            this.pstmt.setBytes(4, rs.getBytes("ATTRIBUTES"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "reservation_customers";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Reservation_Customers\n");
                    this.SQL = "SELECT * FROM reservation_customers";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO reservation_customers(ID, CUSTOMER) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("CUSTOMER"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "reservations";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Reservations\n");
                    this.SQL = "SELECT * FROM reservations";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO reservations(ID, CREATED, DATENEW, TITLE, CHAIRS, ISDONE, DESCRIPTION) VALUES (?, ?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setTimestamp(2, rs.getTimestamp("CREATED"));
                        this.pstmt.setTimestamp(3, rs.getTimestamp("DATENEW"));
                        this.pstmt.setString(4, rs.getString("TITLE"));
                        this.pstmt.setInt(5, rs.getInt("CHAIRS"));
                        this.pstmt.setBoolean(6, rs.getBoolean("ISDONE"));
                        this.pstmt.setString(7, rs.getString("DESCRIPTION"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "roles";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Roles\n");
                    this.SQL = "SELECT * FROM roles WHERE NOT ID='0' ";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO roles(ID, NAME, PERMISSIONS) VALUES (?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.setBytes(3, rs.getBytes("PERMISSIONS"));
                        this.pstmt.executeUpdate();
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "shift_breaks";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Shift_breaks\n");
                        this.SQL = "SELECT * FROM shift_breaks";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO shift_breaks(ID, SHIFTID, BREAKID, STARTTIME, ENDTIME) VALUES (?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("SHIFTID"));
                            this.pstmt.setString(3, rs.getString("BREAKID"));
                            this.pstmt.setTimestamp(4, rs.getTimestamp("STARTTIME"));
                            this.pstmt.setTimestamp(5, rs.getTimestamp("ENDTIME"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Shift Breaks... skipped\n");
                    }
                    if (!this.jlblVersion.getText().startsWith("2")) {
                        Dbtname = "shifts";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Shifts\n");
                        this.SQL = "SELECT * FROM shifts";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO shifts(ID, STARTSHIFT, ENDSHIFT, PPLID) VALUES (?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setTimestamp(2, rs.getTimestamp("STARTSHIFT"));
                            this.pstmt.setTimestamp(3, rs.getTimestamp("ENDSHIFT"));
                            this.pstmt.setString(4, rs.getString("PPLID"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Shifts... skipped\n");
                    }
                    Dbtname = "stockcurrent";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Stockcurrent\n");
                    this.SQL = "SELECT * FROM stockcurrent";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO stockcurrent(LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS) VALUES (?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("LOCATION"));
                        this.pstmt.setString(2, rs.getString("PRODUCT"));
                        this.pstmt.setString(3, rs.getString("ATTRIBUTESETINSTANCE_ID"));
                        this.pstmt.setDouble(4, rs.getDouble("UNITS"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "stockdiary";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Stockdiary\n");
                    this.SQL = "SELECT * FROM stockdiary";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    if (rs.getMetaData().getColumnCount() == 9) {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO stockdiary(ID, DATENEW, REASON, LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE, APPUSER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setTimestamp(2, rs.getTimestamp("DATENEW"));
                            this.pstmt.setInt(3, rs.getInt("REASON"));
                            this.pstmt.setString(4, rs.getString("LOCATION"));
                            this.pstmt.setString(5, rs.getString("PRODUCT"));
                            this.pstmt.setString(6, rs.getString("ATTRIBUTESETINSTANCE_ID"));
                            this.pstmt.setDouble(7, rs.getDouble("UNITS"));
                            this.pstmt.setDouble(8, rs.getDouble("PRICE"));
                            this.pstmt.setString(9, rs.getString("APPUSER"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        while (rs.next()) {
                            this.SQL = "INSERT INTO stockdiary(ID, DATENEW, REASON, LOCATION, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setTimestamp(2, rs.getTimestamp("DATENEW"));
                            this.pstmt.setInt(3, rs.getInt("REASON"));
                            this.pstmt.setString(4, rs.getString("LOCATION"));
                            this.pstmt.setString(5, rs.getString("PRODUCT"));
                            this.pstmt.setString(6, rs.getString("ATTRIBUTESETINSTANCE_ID"));
                            this.pstmt.setDouble(7, rs.getDouble("UNITS"));
                            this.pstmt.setDouble(8, rs.getDouble("PRICE"));
                            this.pstmt.executeUpdate();
                        }
                    }
                    Dbtname = "stocklevel";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Stocklevel\n");
                    this.SQL = "SELECT * FROM stocklevel";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO stocklevel(ID, LOCATION, PRODUCT, STOCKSECURITY, STOCKMAXIMUM) VALUES (?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("LOCATION"));
                        this.pstmt.setString(3, rs.getString("PRODUCT"));
                        this.pstmt.setDouble(4, rs.getDouble("STOCKSECURITY"));
                        this.pstmt.setDouble(5, rs.getDouble("STOCKMAXIMUM"));
                        this.pstmt.executeUpdate();
                    }
                    if (this.jlblVersion.getText().startsWith("4")) {
                        Dbtname = "suppliers";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Suppliers\n");
                        this.SQL = "SELECT * FROM suppliers";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO suppliers(ID, SEARCHKEY, TAXID, NAME, MAXDEBT,ADDRESS, ADDRESS2, POSTAL, CITY, REGION, COUNTRY, FIRSTNAME, LASTNAME, EMAIL, PHONE, PHONE2, FAX, NOTES, VISIBLE, CURDATE, CURDEBT, VATID) VALUES (?, ?, ?, ?, ?,?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("ID"));
                            this.pstmt.setString(2, rs.getString("SEARCHKEY"));
                            this.pstmt.setString(3, rs.getString("TAXID"));
                            this.pstmt.setString(4, rs.getString("NAME"));
                            this.pstmt.setDouble(5, rs.getDouble("MAXDEBT"));
                            this.pstmt.setString(6, rs.getString("ADDRESS"));
                            this.pstmt.setString(7, rs.getString("ADDRESS2"));
                            this.pstmt.setString(8, rs.getString("POSTAL"));
                            this.pstmt.setString(9, rs.getString("CITY"));
                            this.pstmt.setString(10, rs.getString("REGION"));
                            this.pstmt.setString(11, rs.getString("COUNTRY"));
                            this.pstmt.setString(12, rs.getString("FIRSTNAME"));
                            this.pstmt.setString(13, rs.getString("LASTNAME"));
                            this.pstmt.setString(14, rs.getString("EMAIL"));
                            this.pstmt.setString(15, rs.getString("PHONE"));
                            this.pstmt.setString(16, rs.getString("PHONE2"));
                            this.pstmt.setString(17, rs.getString("FAX"));
                            this.pstmt.setString(18, rs.getString("NOTES"));
                            this.pstmt.setBoolean(19, rs.getBoolean("VISIBLE"));
                            this.pstmt.setTimestamp(20, rs.getTimestamp("CURDATE"));
                            this.pstmt.setDouble(21, rs.getDouble("CURDEBT"));
                            this.pstmt.setString(22, rs.getString("VATID"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.SQL = "INSERT INTO suppliers(ID, NAME, SEARCHKEY) VALUES ('0', 'uniCenta', 'unicenta')";
                        this.pstmt.executeUpdate(this.SQL);
                        this.txtOut.append("Added Supplier... uniCenta\n");
                    }
                    Dbtname = "taxcategories";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("TaxCategories\n");
                    this.SQL = "SELECT * FROM taxcategories";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO taxcategories(ID, NAME) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "taxcustcategories";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Tax Customer Categories\n");
                    this.SQL = "SELECT * FROM taxcustcategories";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO taxcustcategories(ID, NAME) VALUES (?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "taxes";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Taxes\n");
                    this.SQL = "SELECT * FROM taxes";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO taxes(ID, NAME, CATEGORY, CUSTCATEGORY, PARENTID, RATE, RATECASCADE, RATEORDER) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("NAME"));
                        this.pstmt.setString(3, rs.getString("CATEGORY"));
                        this.pstmt.setString(4, rs.getString("CUSTCATEGORY"));
                        this.pstmt.setString(5, rs.getString("PARENTID"));
                        this.pstmt.setDouble(6, rs.getDouble("RATE"));
                        this.pstmt.setBoolean(7, rs.getBoolean("RATECASCADE"));
                        this.pstmt.setInt(8, rs.getInt("RATEORDER"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "taxlines";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("TaxLines\n");
                    this.SQL = "SELECT * FROM taxlines";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO taxlines(ID, RECEIPT, TAXID, BASE, AMOUNT) VALUES (?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("RECEIPT"));
                        this.pstmt.setString(3, rs.getString("TAXID"));
                        this.pstmt.setDouble(4, rs.getDouble("BASE"));
                        this.pstmt.setDouble(5, rs.getDouble("AMOUNT"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "thirdparties";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("ThirdParties\n");
                    this.SQL = "SELECT * FROM thirdparties";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO thirdparties(ID, CIF, NAME, ADDRESS, CONTACTCOMM, CONTACTFACT, PAYRULE, FAXNUMBER, PHONENUMBER, MOBILENUMBER, EMAIL, WEBPAGE, NOTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setString(2, rs.getString("CIF"));
                        this.pstmt.setString(3, rs.getString("NAME"));
                        this.pstmt.setString(4, rs.getString("ADDRESS"));
                        this.pstmt.setString(5, rs.getString("CONTACTCOMM"));
                        this.pstmt.setString(6, rs.getString("CONTACTFACT"));
                        this.pstmt.setString(7, rs.getString("PAYRULE"));
                        this.pstmt.setString(8, rs.getString("FAXNUMBER"));
                        this.pstmt.setString(9, rs.getString("PHONENUMBER"));
                        this.pstmt.setString(10, rs.getString("MOBILENUMBER"));
                        this.pstmt.setString(11, rs.getString("EMAIL"));
                        this.pstmt.setString(12, rs.getString("WEBPAGE"));
                        this.pstmt.setString(13, rs.getString("NOTES"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "ticketlines";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("TicketLines\n");
                    this.SQL = "SELECT * FROM ticketlines";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO ticketlines(TICKET, LINE, PRODUCT, ATTRIBUTESETINSTANCE_ID, UNITS, PRICE, TAXID, ATTRIBUTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("TICKET"));
                        this.pstmt.setInt(2, rs.getInt("LINE"));
                        this.pstmt.setString(3, rs.getString("PRODUCT"));
                        this.pstmt.setString(4, rs.getString("ATTRIBUTESETINSTANCE_ID"));
                        this.pstmt.setDouble(5, rs.getDouble("UNITS"));
                        this.pstmt.setDouble(6, rs.getDouble("PRICE"));
                        this.pstmt.setString(7, rs.getString("TAXID"));
                        this.pstmt.setBytes(8, rs.getBytes("ATTRIBUTES"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "tickets";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Tickets\n");
                    this.SQL = "SELECT * FROM tickets";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.SQL = "INSERT INTO tickets(ID, TICKETTYPE, TICKETID, PERSON, CUSTOMER, STATUS) VALUES (?, ?, ?, ?, ?, ?)";
                        this.pstmt = this.con_target.prepareStatement(this.SQL);
                        this.pstmt.setString(1, rs.getString("ID"));
                        this.pstmt.setInt(2, rs.getInt("TICKETTYPE"));
                        this.pstmt.setInt(3, rs.getInt("TICKETID"));
                        this.pstmt.setString(4, rs.getString("PERSON"));
                        this.pstmt.setString(5, rs.getString("CUSTOMER"));
                        this.pstmt.setInt(6, rs.getInt("STATUS"));
                        this.pstmt.executeUpdate();
                    }
                    Dbtname = "ticketsnum";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Tickets Number\n");
                    this.SQL = "SELECT * FROM ticketsnum";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.ticketsnum = rs.getString("ID");
                    }
                    this.SQL = this.ticketsnum != null ? "UPDATE ticketsnum SET ID=" + this.ticketsnum : "UPDATE ticketsnum SET ID='1'";
                    this.stmt_target.executeUpdate(this.SQL);
                    Dbtname = "ticketsnum_payment";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Tickets Number Payments\n");
                    this.SQL = "SELECT * FROM ticketsnum_payment";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.ticketsnumPayment = rs.getString("ID");
                    }
                    this.SQL = this.ticketsnumPayment != null ? "UPDATE ticketsnum_payment SET ID=" + this.ticketsnumPayment : "UPDATE ticketsnum_payment SET ID='1'";
                    this.stmt_target.executeUpdate(this.SQL);
                    Dbtname = "ticketsnum_refund";
                    rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                    this.txtOut.append("Tickets Number Refunds\n");
                    this.SQL = "SELECT * FROM ticketsnum_refund";
                    rs = this.stmt_source.executeQuery(this.SQL);
                    while (rs.next()) {
                        this.ticketsnumRefund = rs.getString("ID");
                    }
                    this.SQL = this.ticketsnumRefund != null ? "UPDATE ticketsnum_refund SET ID=" + this.ticketsnumRefund : "UPDATE ticketsnum_refund SET ID='1'";
                    this.stmt_target.executeUpdate(this.SQL);
                    if (this.jlblVersion.getText().startsWith("4")) {
                        Dbtname = "uom";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("UOM\n");
                        this.SQL = "SELECT * FROM uom";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO uom(id, name) VALUES (?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("id"));
                            this.pstmt.setString(2, rs.getString("name"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.SQL = "INSERT INTO uom(ID, NAME) VALUES ('0', 'Each')";
                        this.pstmt.executeUpdate(this.SQL);
                        this.txtOut.append("Added UOM... Each\n");
                    }
                    if (this.jlblVersion.getText().startsWith("4")) {
                        Dbtname = "vouchers";
                        rs = this.con_source.getMetaData().getTables(null, null, Dbtname, null);
                        this.txtOut.append("Vouchers\n");
                        this.SQL = "SELECT * FROM vouchers";
                        rs = this.stmt_source.executeQuery(this.SQL);
                        while (rs.next()) {
                            this.SQL = "INSERT INTO vouchers(id, voucher_number, customer, amount, status) VALUES (?, ?, ?, ?, ?)";
                            this.pstmt = this.con_target.prepareStatement(this.SQL);
                            this.pstmt.setString(1, rs.getString("id"));
                            this.pstmt.setString(2, rs.getString("voucher_number"));
                            this.pstmt.setString(3, rs.getString("customer"));
                            this.pstmt.setDouble(4, rs.getDouble("amount"));
                            this.pstmt.setString(5, rs.getString("status"));
                            this.pstmt.executeUpdate();
                        }
                    } else {
                        this.txtOut.append("Vouchers... skipped\n");
                    }
                    try {
                        this.con_target.setAutoCommit(true);
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Transfer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.transfercomplete"), AppLocal.getIntString("message.transfermessage"), 2);
                    this.FKeys();
                    this.txtOut.append("Data Transfer Complete\n");
                    this.webPBar.setString("Finished!");
                    this.webPBar.setBgBottom(Color.GREEN);
                    this.jbtnTransfer.setEnabled(true);
                    JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.indexcomplete"), AppLocal.getIntString("message.transfermessage"), 2);
                }
                catch (HeadlessException | SQLException e) {
                    JMessageDialog.showMessage(this, new MessageInf(-33554432, this.SQL, e));
                }
            } else {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, AppLocal.getIntString("message.transfernotsupported"), AppLocal.getIntString("message.transfermessage"), 2);
            }
            this.session_source.close();
        }
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.cbSource = new WebComboBox();
        this.jtxtDbDriverLib = new WebTextField();
        this.jbtnDbDriverLib = new JButton();
        this.jtxtDbDriver = new WebTextField();
        this.jtxtDbType = new WebTextField();
        this.jlblVersion = new JLabel();
        this.txtDbUser = new WebTextField();
        this.txtDbPass = new WebPasswordField();
        this.jScrollPane1 = new JScrollPane();
        this.txtOut = new JTextArea();
        this.jLabel8 = new JLabel();
        this.jlblSource = new JLabel();
        this.jbtnExit = new JButton();
        this.jLabel9 = new JLabel();
        this.jbtnTest = new JButton();
        this.jbtnTransfer = new JButton();
        this.webPBar = new WebProgressBar();
        this.jLabel11 = new JLabel();
        this.jlblDBSize = new JLabel();
        this.jtxtDbServerPort = new WebTextField();
        this.jtxtDbName = new WebTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jtxtDbParams = new WebTextField();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Arial", 0, 14));
        this.setPreferredSize(new Dimension(900, 425));
        this.jLabel5.setFont(new Font("Arial", 0, 14));
        this.jLabel5.setForeground(new Color(102, 102, 102));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jLabel5.setText(bundle.getString("label.DbType"));
        this.jLabel5.setMaximumSize(new Dimension(150, 30));
        this.jLabel5.setMinimumSize(new Dimension(150, 30));
        this.jLabel5.setPreferredSize(new Dimension(160, 30));
        this.jLabel18.setFont(new Font("Arial", 0, 14));
        this.jLabel18.setForeground(new Color(102, 102, 102));
        this.jLabel18.setText(AppLocal.getIntString("label.dbdriverlib"));
        this.jLabel18.setMaximumSize(new Dimension(150, 30));
        this.jLabel18.setMinimumSize(new Dimension(150, 30));
        this.jLabel18.setPreferredSize(new Dimension(160, 30));
        this.jLabel1.setFont(new Font("Arial", 0, 14));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setText(AppLocal.getIntString("label.DbDriver"));
        this.jLabel1.setMaximumSize(new Dimension(150, 30));
        this.jLabel1.setMinimumSize(new Dimension(150, 30));
        this.jLabel1.setPreferredSize(new Dimension(160, 30));
        this.jLabel2.setFont(new Font("Arial", 0, 14));
        this.jLabel2.setForeground(new Color(102, 102, 102));
        this.jLabel2.setText("Type");
        this.jLabel2.setMaximumSize(new Dimension(150, 30));
        this.jLabel2.setMinimumSize(new Dimension(150, 30));
        this.jLabel2.setPreferredSize(new Dimension(160, 30));
        this.jLabel7.setFont(new Font("Arial", 0, 14));
        this.jLabel7.setForeground(new Color(102, 102, 102));
        this.jLabel7.setText("DB Version");
        this.jLabel7.setMaximumSize(new Dimension(150, 30));
        this.jLabel7.setMinimumSize(new Dimension(150, 30));
        this.jLabel7.setPreferredSize(new Dimension(160, 30));
        this.jLabel3.setFont(new Font("Arial", 0, 14));
        this.jLabel3.setForeground(new Color(102, 102, 102));
        this.jLabel3.setText(AppLocal.getIntString("label.DbUser"));
        this.jLabel3.setMaximumSize(new Dimension(150, 30));
        this.jLabel3.setMinimumSize(new Dimension(150, 30));
        this.jLabel3.setPreferredSize(new Dimension(160, 30));
        this.jLabel4.setFont(new Font("Arial", 0, 14));
        this.jLabel4.setForeground(new Color(102, 102, 102));
        this.jLabel4.setText(AppLocal.getIntString("label.DbPassword"));
        this.jLabel4.setMaximumSize(new Dimension(150, 30));
        this.jLabel4.setMinimumSize(new Dimension(150, 30));
        this.jLabel4.setPreferredSize(new Dimension(100, 30));
        this.jLabel6.setFont(new Font("Arial", 0, 18));
        this.jLabel6.setForeground(new Color(51, 51, 51));
        this.jLabel6.setText("TRANSFER TO :");
        this.jLabel6.setPreferredSize(new Dimension(150, 30));
        this.cbSource.setForeground(new Color(51, 51, 51));
        this.cbSource.setToolTipText(bundle.getString("tooltip.transferfromdb"));
        this.cbSource.setFont(new Font("Arial", 0, 14));
        this.cbSource.setPreferredSize(new Dimension(150, 30));
        this.cbSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Transfer.this.cbSourceActionPerformed(evt);
            }
        });
        this.jtxtDbDriverLib.setForeground(new Color(51, 51, 51));
        this.jtxtDbDriverLib.setToolTipText(bundle.getString("tootltip.transferlib"));
        this.jtxtDbDriverLib.setFont(new Font("Arial", 0, 14));
        this.jtxtDbDriverLib.setPreferredSize(new Dimension(360, 30));
        this.jbtnDbDriverLib.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/fileopen.png")));
        this.jbtnDbDriverLib.setToolTipText(bundle.getString("tooltip.openfile"));
        this.jbtnDbDriverLib.setMaximumSize(new Dimension(64, 32));
        this.jbtnDbDriverLib.setMinimumSize(new Dimension(64, 32));
        this.jbtnDbDriverLib.setPreferredSize(new Dimension(60, 30));
        this.jtxtDbDriver.setForeground(new Color(51, 51, 51));
        this.jtxtDbDriver.setToolTipText(bundle.getString("tootltip.transferclass"));
        this.jtxtDbDriver.setFont(new Font("Arial", 0, 14));
        this.jtxtDbDriver.setPreferredSize(new Dimension(360, 30));
        this.jtxtDbType.setForeground(new Color(51, 51, 51));
        this.jtxtDbType.setToolTipText(bundle.getString("tootltip.transferdbtype"));
        this.jtxtDbType.setFont(new Font("Arial", 0, 14));
        this.jtxtDbType.setPreferredSize(new Dimension(150, 30));
        this.jlblVersion.setFont(new Font("Arial", 0, 16));
        this.jlblVersion.setForeground(new Color(0, 204, 255));
        this.jlblVersion.setHorizontalAlignment(0);
        this.jlblVersion.setToolTipText(bundle.getString("tooltip.transferdbversion"));
        this.jlblVersion.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 255)));
        this.jlblVersion.setMaximumSize(new Dimension(150, 30));
        this.jlblVersion.setMinimumSize(new Dimension(150, 30));
        this.jlblVersion.setPreferredSize(new Dimension(125, 30));
        this.txtDbUser.setForeground(new Color(51, 51, 51));
        this.txtDbUser.setToolTipText(bundle.getString("tooltip.dbuser"));
        this.txtDbUser.setFont(new Font("Arial", 0, 14));
        this.txtDbUser.setPreferredSize(new Dimension(125, 30));
        this.txtDbPass.setForeground(new Color(51, 51, 51));
        this.txtDbPass.setToolTipText(bundle.getString("tooltip.dbpassword"));
        this.txtDbPass.setFont(new Font("Arial", 0, 14));
        this.txtDbPass.setPreferredSize(new Dimension(125, 30));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jScrollPane1.setFont(new Font("Arial", 0, 13));
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 350));
        this.txtOut.setColumns(20);
        this.txtOut.setFont(new Font("Arial", 0, 12));
        this.txtOut.setForeground(new Color(0, 153, 255));
        this.txtOut.setRows(5);
        this.txtOut.setToolTipText(bundle.getString("tooltip.transfertxtout"));
        this.txtOut.setBorder(null);
        this.jScrollPane1.setViewportView(this.txtOut);
        this.jLabel8.setFont(new Font("Arial", 0, 18));
        this.jLabel8.setForeground(new Color(0, 153, 255));
        this.jLabel8.setText("PROGRESS");
        this.jLabel8.setPreferredSize(new Dimension(150, 30));
        this.jlblSource.setFont(new Font("Arial", 0, 18));
        this.jlblSource.setForeground(new Color(0, 153, 255));
        this.jlblSource.setHorizontalAlignment(2);
        this.jlblSource.setPreferredSize(new Dimension(150, 30));
        this.jbtnExit.setFont(new Font("Arial", 0, 12));
        this.jbtnExit.setText(AppLocal.getIntString("Button.Exit"));
        this.jbtnExit.setToolTipText(bundle.getString("tooltip.exit"));
        this.jbtnExit.setMaximumSize(new Dimension(70, 33));
        this.jbtnExit.setMinimumSize(new Dimension(70, 33));
        this.jbtnExit.setPreferredSize(new Dimension(80, 45));
        this.jbtnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Transfer.this.jbtnExitActionPerformed(evt);
            }
        });
        this.jLabel9.setFont(new Font("Arial", 0, 14));
        this.jLabel9.setForeground(new Color(102, 102, 102));
        this.jLabel9.setText(AppLocal.getIntString("label.DbUser"));
        this.jLabel9.setMaximumSize(new Dimension(150, 30));
        this.jLabel9.setMinimumSize(new Dimension(150, 30));
        this.jLabel9.setPreferredSize(new Dimension(160, 30));
        this.jbtnTest.setFont(new Font("Arial", 0, 14));
        this.jbtnTest.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/database.png")));
        this.jbtnTest.setText(bundle.getString("Button.Test"));
        this.jbtnTest.setToolTipText(bundle.getString("tooltip.dbtest"));
        this.jbtnTest.setActionCommand(bundle.getString("Button.Test"));
        this.jbtnTest.setPreferredSize(new Dimension(160, 45));
        this.jbtnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Transfer.this.jbtnTestjButtonTestConnectionActionPerformed(evt);
            }
        });
        this.jbtnTransfer.setFont(new Font("Arial", 0, 14));
        this.jbtnTransfer.setText(AppLocal.getIntString("button.transfer"));
        this.jbtnTransfer.setToolTipText(bundle.getString("tooltip.transferdb"));
        this.jbtnTransfer.setMaximumSize(new Dimension(70, 33));
        this.jbtnTransfer.setMinimumSize(new Dimension(70, 33));
        this.jbtnTransfer.setPreferredSize(new Dimension(160, 45));
        this.jbtnTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Transfer.this.jbtnTransferActionPerformed(evt);
            }
        });
        this.webPBar.setFont(new Font("Arial", 0, 13));
        this.webPBar.setHighlightDarkWhite(new Color(204, 0, 0));
        this.webPBar.setPreferredSize(new Dimension(240, 30));
        this.webPBar.setProgressBottomColor(new Color(0, 153, 255));
        this.jLabel11.setFont(new Font("Arial", 0, 14));
        this.jLabel11.setForeground(new Color(102, 102, 102));
        this.jLabel11.setText("DB Size");
        this.jLabel11.setMaximumSize(new Dimension(150, 30));
        this.jLabel11.setMinimumSize(new Dimension(150, 30));
        this.jLabel11.setPreferredSize(new Dimension(100, 30));
        this.jlblDBSize.setFont(new Font("Arial", 0, 16));
        this.jlblDBSize.setForeground(new Color(0, 204, 255));
        this.jlblDBSize.setHorizontalAlignment(0);
        this.jlblDBSize.setToolTipText(bundle.getString("tooltip.transferdbsize"));
        this.jlblDBSize.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 255)));
        this.jlblDBSize.setMaximumSize(new Dimension(150, 30));
        this.jlblDBSize.setMinimumSize(new Dimension(150, 30));
        this.jlblDBSize.setPreferredSize(new Dimension(125, 30));
        this.jtxtDbServerPort.setForeground(new Color(51, 51, 51));
        this.jtxtDbServerPort.setToolTipText(bundle.getString("tootltip.servernameport"));
        this.jtxtDbServerPort.setFont(new Font("Arial", 0, 14));
        this.jtxtDbServerPort.setPreferredSize(new Dimension(360, 30));
        this.jtxtDbName.setForeground(new Color(51, 51, 51));
        this.jtxtDbName.setToolTipText(bundle.getString("tootltip.transferdbname"));
        this.jtxtDbName.setFont(new Font("Arial", 0, 14));
        this.jtxtDbName.setPreferredSize(new Dimension(360, 30));
        this.jLabel12.setFont(new Font("Arial", 0, 14));
        this.jLabel12.setForeground(new Color(102, 102, 102));
        this.jLabel12.setText(bundle.getString("labelServerPort"));
        this.jLabel12.setMaximumSize(new Dimension(150, 30));
        this.jLabel12.setMinimumSize(new Dimension(150, 30));
        this.jLabel12.setPreferredSize(new Dimension(160, 30));
        this.jLabel13.setFont(new Font("Arial", 0, 14));
        this.jLabel13.setForeground(new Color(102, 102, 102));
        this.jLabel13.setText(bundle.getString("label.DbSource"));
        this.jLabel13.setMaximumSize(new Dimension(150, 30));
        this.jLabel13.setMinimumSize(new Dimension(150, 30));
        this.jLabel13.setPreferredSize(new Dimension(160, 30));
        this.jLabel14.setFont(new Font("Arial", 0, 14));
        this.jLabel14.setForeground(new Color(102, 102, 102));
        this.jLabel14.setText(bundle.getString("label.DBParameters"));
        this.jLabel14.setMaximumSize(new Dimension(150, 30));
        this.jLabel14.setMinimumSize(new Dimension(150, 30));
        this.jLabel14.setPreferredSize(new Dimension(160, 30));
        this.jtxtDbParams.setForeground(new Color(51, 51, 51));
        this.jtxtDbParams.setToolTipText(bundle.getString("tootltip.transferdbparams"));
        this.jtxtDbParams.setFont(new Font("Arial", 0, 14));
        this.jtxtDbParams.setPreferredSize(new Dimension(360, 30));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cbSource, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jbtnTest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnTransfer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnExit, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlblSource, -2, 470, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jtxtDbName, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, -2).addComponent(this.jLabel7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.txtDbUser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jlblVersion, -2, -1, -2).addGap(7, 7, 7).addComponent(this.jLabel11, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlblDBSize, -2, 123, -2).addComponent((Component)this.txtDbPass, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, -2).addComponent(this.jLabel12, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jtxtDbType, -2, -1, -2).addComponent((Component)this.jtxtDbServerPort, -1, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jtxtDbParams, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18, -1, -1, -2).addComponent(this.jLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jtxtDbDriver, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent((Component)this.jtxtDbDriverLib, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnDbDriverLib, -2, -1, -2))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9, 0, 0, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.webPBar, -2, 109, -2)).addComponent(this.jScrollPane1, -2, 240, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlblSource, -2, -1, -2).addComponent((Component)this.webPBar, -2, 32, -2).addComponent(this.jLabel8, -2, -1, -2).addComponent(this.jLabel6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 519, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cbSource, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel18, -2, -1, -2).addComponent((Component)this.jtxtDbDriverLib, -2, -1, -2).addComponent(this.jbtnDbDriverLib, -2, 39, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent((Component)this.jtxtDbDriver, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jtxtDbType, -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12, -2, -1, -2).addComponent((Component)this.jtxtDbServerPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jtxtDbName, -2, -1, -2).addComponent(this.jLabel13, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jtxtDbParams, -2, -1, -2).addComponent(this.jLabel14, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent((Component)this.txtDbPass, -2, -1, -2).addComponent((Component)this.txtDbUser, -2, -1, -2).addComponent(this.jLabel4, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jlblVersion, -2, -1, -2).addComponent(this.jLabel11, -2, -1, -2))).addComponent(this.jlblDBSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbtnTest, -2, -1, -2).addComponent(this.jbtnTransfer, -2, -1, -2).addComponent(this.jbtnExit, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jLabel1.getAccessibleContext().setAccessibleName("DBDriver");
    }

    private void jbtnTransferActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.transfer"), AppLocal.getIntString("message.transfertitle"), 0, 3) == 0) {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Transfer.this.webPBar.setString("Starting...");
                    Transfer.this.doTransfer();
                    return null;
                }
            };
            worker.execute();
        }
        System.gc();
    }

    private void jbtnExitActionPerformed(ActionEvent evt) {
        this.session_source.close();
        this.deactivate();
    }

    private void jbtnTestjButtonTestConnectionActionPerformed(ActionEvent evt) {
        try {
            boolean isValid;
            String driverlib = this.jtxtDbDriverLib.getText();
            String driver = this.jtxtDbDriver.getText();
            String url = this.jtxtDbType.getText() + this.jtxtDbServerPort.getText() + this.jtxtDbName.getText() + this.jtxtDbParams.getText();
            String user = this.txtDbUser.getText();
            String password = new String(this.txtDbPass.getPassword());
            URLClassLoader cloader = new URLClassLoader(new URL[]{new File(driverlib).toURI().toURL()});
            DriverManager.registerDriver(new DriverWrapper((Driver)Class.forName(driver, true, cloader).newInstance()));
            Session session_source = new Session(url, user, password);
            Connection connection = session_source.getConnection();
            boolean bl = isValid = connection == null ? false : connection.isValid(1000);
            if (isValid) {
                this.SQL = "SELECT * FROM applications";
                Statement stmt = connection.createStatement();
                this.rs = stmt.executeQuery(this.SQL);
                this.rs.next();
                this.jlblVersion.setText(this.rs.getString(3));
                this.stringList.add("Version check... " + this.rs.getString(3) + "\n");
                this.txtOut.setText(this.stringList.get(1));
                if ("jdbc:mysql:".equals(this.jtxtDbType.getText())) {
                    this.SQL = "SELECT sum(round(((data_length + index_length) / 1024 / 1024), 2))  FROM information_schema.TABLES WHERE table_schema = '" + this.jtxtDbName.getText() + "'";
                    this.rs = stmt.executeQuery(this.SQL);
                    this.rs.next();
                    this.jlblDBSize.setText(this.rs.getString(1) + "MB");
                } else if ("jdbc:derby:".equals(this.jtxtDbType.getText())) {
                    this.SQL = "SELECT SUM((numallocatedpages * pagesize) /1024) /1024 FROM SYS.SYSTABLES systabs, SYS.SYSSCHEMAS sysschemas, TABLE (SYSCS_DIAG.SPACE_TABLE()) AS T2 WHERE systabs.tabletype = 'T' AND sysschemas.schemaid = systabs.schemaid AND systabs.tableid = T2.tableid";
                    this.rs = stmt.executeQuery(this.SQL);
                    this.rs.next();
                    this.jlblDBSize.setText(this.rs.getString(1) + "MB");
                } else if ("jdbc:postgresql:".equals(this.jtxtDbType.getText())) {
                    this.SQL = "SELECT pg_size_pretty(pg_database_size(current database()))";
                    this.rs = stmt.executeQuery(this.SQL);
                    this.rs.next();
                    this.jlblDBSize.setText(this.rs.getString(1));
                }
                JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.databaseconnectsuccess"), "Connection Test", 1);
                this.jbtnTransfer.setEnabled(true);
            } else {
                JMessageDialog.showMessage(this, new MessageInf(-33554432, "Connection Error"));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException e) {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.databasedrivererror"), e));
        }
        catch (SQLException e) {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.databaseconnectionerror"), e));
        }
        catch (Exception e) {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, "Unknown exception", e));
        }
    }

    private void cbSourceActionPerformed(ActionEvent evt) {
        String dirname = System.getProperty("dirname.path");
        String string = dirname = dirname == null ? "./" : dirname;
        if ("Derby".equals(this.cbSource.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "/lib/derby-10.10.2.0.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.apache.derby.jdbc.EmbeddedDriver");
            this.jtxtDbType.setText("jdbc:derby:");
            this.jtxtDbServerPort.setText("" + new File(new File(System.getProperty("user.home")), ""));
            this.jtxtDbName.setText("/unicentaopos-database");
            this.jtxtDbParams.setText("");
            this.txtDbUser.setText("");
            this.txtDbPass.setText("");
        } else if ("PostgreSQL".equals(this.cbSource.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "/lib/postgresql-9.4-1208.jdbc4.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.postgresql.Driver");
            this.jtxtDbType.setText("jdbc:postgresql://");
            this.jtxtDbServerPort.setText("localhost:5432/");
            this.jtxtDbName.setText("unicentaopos");
            this.jtxtDbParams.setText("");
        } else {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "/lib/mysql-connector-java-5.1.39.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("com.mysql.jdbc.Driver");
            this.jtxtDbType.setText("jdbc:mysql://");
            this.jtxtDbServerPort.setText("localhost:3306/");
            this.jtxtDbName.setText("unicentaopos");
            this.jtxtDbParams.setText("?zeroDateTimeBehavior=convertToNull");
        }
        this.txtDbUser.setText("");
        this.txtDbPass.setText("");
        this.jlblVersion.setText("");
        this.jlblDBSize.setText("");
    }
}

