/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales.restaurant;

import bsh.EvalError;
import bsh.Interpreter;
import com.alee.extended.time.ClockType;
import com.alee.extended.time.WebClock;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationManager;
import com.alee.managers.notification.WebNotification;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.JNumberPop;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.ListKeyed;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.SentenceList;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.DataLogicSales;
import com.openbravo.pos.forms.DataLogicSystem;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.printer.DeviceTicket;
import com.openbravo.pos.printer.TicketParser;
import com.openbravo.pos.printer.TicketPrinterException;
import com.openbravo.pos.sales.DataLogicReceipts;
import com.openbravo.pos.sales.JPanelTicket;
import com.openbravo.pos.sales.TaxesLogic;
import com.openbravo.pos.sales.restaurant.JTicketsBagRestaurantMap;
import com.openbravo.pos.sales.restaurant.RestaurantDBUtils;
import com.openbravo.pos.scripting.ScriptEngine;
import com.openbravo.pos.scripting.ScriptException;
import com.openbravo.pos.scripting.ScriptFactory;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JTicketsBagRestaurant
extends JPanel {
    private final AppView m_App;
    private final JTicketsBagRestaurantMap m_restaurant;
    private List<TicketLineInfo> m_aLines;
    private TicketLineInfo line;
    private TicketInfo ticket;
    private final Object ticketExt;
    private DataLogicSystem m_dlSystem = null;
    private final DeviceTicket m_TP;
    private final TicketParser m_TTP2;
    private final RestaurantDBUtils restDB;
    private final DataLogicSystem dlSystem = null;
    private final DataLogicReceipts dlReceipts = null;
    private DataLogicSales dlSales = null;
    private TicketParser m_TTP;
    private SentenceList senttax;
    private ListKeyed taxcollection;
    private TaxesLogic taxeslogic;
    private Interpreter i;
    private JButton j_btnKitchen;
    private JButton m_DelTicket;
    private JButton m_MoveTable;
    private JButton m_TablePlan;

    public JTicketsBagRestaurant(AppView app, JTicketsBagRestaurantMap restaurant) {
        this.m_App = app;
        this.m_restaurant = restaurant;
        this.initComponents();
        this.ticketExt = null;
        this.restDB = new RestaurantDBUtils(this.m_App);
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSales");
        DataLogicReceipts m_dlReceipts = (DataLogicReceipts)this.m_App.getBean("com.openbravo.pos.sales.DataLogicReceipts");
        this.m_TP = new DeviceTicket();
        this.m_TTP2 = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
        this.j_btnKitchen.setVisible(true);
        this.m_TablePlan.setVisible(this.m_App.getAppUserView().getUser().hasPermission("sales.TablePlan"));
    }

    public void activate() {
        this.m_DelTicket.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("com.openbravo.pos.sales.JPanelTicketEdits"));
        this.m_TablePlan.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("com.openbravo.pos.sales.JPanelTicketEdits"));
        this.m_TablePlan.setVisible(true);
    }

    public String getPickupString(TicketInfo pTicket) {
        if (pTicket == null) {
            return "0";
        }
        String tmpPickupId = Integer.toString(pTicket.getPickupId());
        String pickupSize = this.m_App.getProperties().getProperty("till.pickupsize");
        if (pickupSize != null && Integer.parseInt(pickupSize) >= tmpPickupId.length()) {
            while (tmpPickupId.length() < Integer.parseInt(pickupSize)) {
                tmpPickupId = "0" + tmpPickupId;
            }
        }
        return tmpPickupId;
    }

    public void printTicket(String resource) {
        this.printTicket(resource, this.ticket, this.m_restaurant.getTable());
        this.printNotify();
        this.j_btnKitchen.setEnabled(false);
    }

    private void printTicket(String sresourcename, TicketInfo ticket, String table) {
        if (ticket != null) {
            if (ticket.getPickupId() == 0) {
                try {
                    ticket.setPickupId(this.dlSales.getNextPickupIndex());
                }
                catch (BasicException e) {
                    ticket.setPickupId(0);
                }
            }
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticket", ticket);
                script.put("place", this.m_restaurant.getTableName());
                script.put("pickupid", this.getPickupString(ticket));
                this.m_TTP2.printTicket(script.eval(this.m_dlSystem.getResourceAsXML(sresourcename)).toString());
            }
            catch (TicketPrinterException | ScriptException e) {
                JMessageDialog.showMessage(this, new MessageInf(-67108864, AppLocal.getIntString("message.cannotprint"), e));
            }
        }
    }

    public void printNotify() {
        WebNotification notificationPopup = new WebNotification();
        notificationPopup.setIcon(NotificationIcon.information);
        notificationPopup.setDisplayTime(4000L);
        WebClock clock = new WebClock();
        clock.setClockType(ClockType.timer);
        clock.setTimeLeft(5000L);
        clock.setTimePattern("'Printed successfully'");
        notificationPopup.setContent((Component)clock);
        NotificationManager.showNotification((WebNotification)notificationPopup);
        clock.start();
    }

    private void initComponents() {
        this.m_TablePlan = new JButton();
        this.m_MoveTable = new JButton();
        this.m_DelTicket = new JButton();
        this.j_btnKitchen = new JButton();
        this.setFont(new Font("Arial", 0, 12));
        this.setMinimumSize(new Dimension(250, 50));
        this.setPreferredSize(new Dimension(350, 50));
        this.setLayout(new FlowLayout(0));
        this.m_TablePlan.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/tables.png")));
        this.m_TablePlan.setToolTipText("Go to Table Plan");
        this.m_TablePlan.setFocusPainted(false);
        this.m_TablePlan.setFocusable(false);
        this.m_TablePlan.setMargin(new Insets(0, 4, 0, 4));
        this.m_TablePlan.setMaximumSize(new Dimension(50, 40));
        this.m_TablePlan.setMinimumSize(new Dimension(50, 40));
        this.m_TablePlan.setPreferredSize(new Dimension(80, 45));
        this.m_TablePlan.setRequestFocusEnabled(false);
        this.m_TablePlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurant.this.m_TablePlanActionPerformed(evt);
            }
        });
        this.add(this.m_TablePlan);
        this.m_MoveTable.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/movetable.png")));
        this.m_MoveTable.setToolTipText("Move Table");
        this.m_MoveTable.setFocusPainted(false);
        this.m_MoveTable.setFocusable(false);
        this.m_MoveTable.setMargin(new Insets(0, 4, 0, 4));
        this.m_MoveTable.setMaximumSize(new Dimension(50, 40));
        this.m_MoveTable.setMinimumSize(new Dimension(50, 40));
        this.m_MoveTable.setPreferredSize(new Dimension(80, 45));
        this.m_MoveTable.setRequestFocusEnabled(false);
        this.m_MoveTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurant.this.m_MoveTableActionPerformed(evt);
            }
        });
        this.add(this.m_MoveTable);
        this.m_DelTicket.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_delete.png")));
        this.m_DelTicket.setToolTipText("Delete Current Order");
        this.m_DelTicket.setFocusPainted(false);
        this.m_DelTicket.setFocusable(false);
        this.m_DelTicket.setMargin(new Insets(0, 4, 0, 4));
        this.m_DelTicket.setMaximumSize(new Dimension(50, 40));
        this.m_DelTicket.setMinimumSize(new Dimension(50, 40));
        this.m_DelTicket.setPreferredSize(new Dimension(80, 45));
        this.m_DelTicket.setRequestFocusEnabled(false);
        this.m_DelTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurant.this.m_DelTicketActionPerformed(evt);
            }
        });
        this.add(this.m_DelTicket);
        this.j_btnKitchen.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/printer24.png")));
        this.j_btnKitchen.setToolTipText("Send to Kichen Printer");
        this.j_btnKitchen.setMargin(new Insets(0, 4, 0, 4));
        this.j_btnKitchen.setMaximumSize(new Dimension(50, 40));
        this.j_btnKitchen.setMinimumSize(new Dimension(50, 40));
        this.j_btnKitchen.setPreferredSize(new Dimension(80, 45));
        this.j_btnKitchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTicketsBagRestaurant.this.j_btnKitchenActionPerformed(evt);
            }
        });
        this.add(this.j_btnKitchen);
        this.j_btnKitchen.getAccessibleContext().setAccessibleDescription("Send to Remote Printer");
    }

    private void m_MoveTableActionPerformed(ActionEvent evt) {
        this.restDB.clearCustomerNameInTableById(this.m_restaurant.getTable());
        this.restDB.clearWaiterNameInTableById(this.m_restaurant.getTable());
        this.restDB.setTableMovedFlag(this.m_restaurant.getTable());
        this.m_restaurant.moveTicket();
    }

    private void m_DelTicketActionPerformed(ActionEvent evt) {
        int res;
        boolean pinOK = false;
        if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
            Integer secret = Integer.parseInt(this.m_App.getProperties().getProperty("override.pin"));
            Integer iValue = JNumberPop.showEditNumber(this, AppLocal.getIntString("title.override.enterpin"));
            if (iValue == null ? secret == null : iValue.equals(secret)) {
                pinOK = true;
                int res2 = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannadelete"), AppLocal.getIntString("title.editor"), 0, 3);
                if (res2 == 0) {
                    this.restDB.clearCustomerNameInTableById(this.m_restaurant.getTable());
                    this.restDB.clearWaiterNameInTableById(this.m_restaurant.getTable());
                    this.restDB.clearTicketIdInTableById(this.m_restaurant.getTable());
                    this.m_restaurant.deleteTicket();
                }
            } else {
                pinOK = false;
                JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.override.badpin"));
            }
        }
        if ((res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannadelete"), AppLocal.getIntString("title.editor"), 0, 3)) == 0) {
            this.restDB.clearCustomerNameInTableById(this.m_restaurant.getTable());
            this.restDB.clearWaiterNameInTableById(this.m_restaurant.getTable());
            this.restDB.clearTicketIdInTableById(this.m_restaurant.getTable());
            this.m_restaurant.deleteTicket();
        }
    }

    private void m_TablePlanActionPerformed(ActionEvent evt) {
        this.m_restaurant.newTicket();
    }

    private void j_btnKitchenActionPerformed(ActionEvent evt) {
        this.ticket = this.m_restaurant.getActiveTicket();
        String rScript = this.m_dlSystem.getResourceAsText("script.SendOrder");
        Interpreter i = new Interpreter();
        try {
            i.set("ticket", (Object)this.ticket);
            i.set("place", (Object)this.m_restaurant.getTableName());
            i.set("user", (Object)this.m_App.getAppUserView().getUser());
            i.set("sales", (Object)this);
            i.set("pickupid", this.ticket.getPickupId());
            Object object = i.eval(rScript);
        }
        catch (EvalError ex) {
            Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
        }
        String autoLogoff = this.m_App.getProperties().getProperty("till.autoLogoff");
        String autoLogoffRestaurant = this.m_App.getProperties().getProperty("till.autoLogoffrestaurant");
        if (autoLogoff != null && autoLogoff.equals("true")) {
            if (autoLogoffRestaurant == null) {
                ((JRootApp)this.m_App).closeAppView();
            } else if (autoLogoffRestaurant.equals("true")) {
                this.m_restaurant.newTicket();
            } else {
                ((JRootApp)this.m_App).closeAppView();
            }
        }
    }
}

