/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.imports;

import com.alee.laf.progressbar.WebProgressBar;
import com.csvreader.CsvReader;
import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.Datas;
import com.openbravo.data.loader.PreparedSentence;
import com.openbravo.data.loader.SerializerWriteBasicExt;
import com.openbravo.data.loader.Session;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.AppViewConnection;
import com.openbravo.pos.forms.DataLogicSales;
import com.openbravo.pos.forms.DataLogicSystem;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.imports.JPanelCSVImport;
import com.openbravo.pos.inventory.ProductStock;
import com.openbravo.pos.ticket.ProductInfoExt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class StockQtyImport
extends JPanel
implements JPanelView {
    private AppProperties m_props;
    private Properties m_propsdb = null;
    private CsvReader products;
    private DocumentListener documentListener;
    private Session s;
    private Connection con;
    private DataLogicSales m_dlSales;
    private DataLogicSystem m_dlSystem;
    private ProductInfoExt prodInfo;
    private ProductStock prodStock;
    private String Location = "0";
    private String m_sInventoryLocation;
    private String productBarcode;
    private Double productQty;
    private double oldQty = 0.0;
    private double newQty = 0.0;
    private String recordType = null;
    private String last_folder;
    private File config_file;
    private String csvFileName;
    private Integer progress = 0;
    private int currentRecord;
    private int rowCount = 0;
    private int qtyUpdates = 0;
    private JComboBox jComboSeparator;
    private JPanel jFileChooserPanel;
    private JTextField jFileName;
    private JButton jFileRead;
    private JButton jImport;
    private JLabel jLabel1;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JTextField jTextRecords;
    private JTextField jTextUpdate;
    private JLabel jTextUpdates;
    private JButton jbtnFileChoose;
    private JButton jbtnReset;
    private JLabel m_jLocation;
    private WebProgressBar webPBar;

    public StockQtyImport(AppView oApp) {
        this(oApp.getProperties());
    }

    public StockQtyImport(AppProperties props) {
        this.initComponents();
        AppProperties m_props = props;
        try {
            this.s = AppViewConnection.createSession(props);
            this.con = this.s.getConnection();
        }
        catch (BasicException | SQLException exception) {
            // empty catch block
        }
        this.m_dlSales = new DataLogicSales();
        this.m_dlSales.init(this.s);
        this.m_dlSystem = new DataLogicSystem();
        this.m_dlSystem.init(this.s);
        Properties m_propsdb = this.m_dlSystem.getResourceAsProperties(m_props.getHost() + "/properties");
        this.m_sInventoryLocation = m_propsdb.getProperty("location");
        try {
            this.Location = this.m_dlSystem.findLocationName(this.m_sInventoryLocation);
        }
        catch (BasicException ex) {
            Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.last_folder = props.getProperty("CSV.last_folder");
        this.config_file = props.getConfigFile();
        this.jFileName.getDocument().addDocumentListener(this.documentListener);
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                StockQtyImport.this.jFileRead.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!"".equals(StockQtyImport.this.jFileName.getText().trim())) {
                    StockQtyImport.this.jFileRead.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (StockQtyImport.this.jFileName.getText().trim().equals("")) {
                    StockQtyImport.this.jFileRead.setEnabled(false);
                }
            }
        };
    }

    private void enableForm() {
        this.jFileRead.setEnabled(true);
        this.jImport.setEnabled(true);
        this.jbtnReset.setEnabled(true);
        this.m_jLocation.setEnabled(true);
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.CSVImport");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        this.m_jLocation.setText("Current Location : " + this.Location);
        this.jComboSeparator.removeAllItems();
        this.jComboSeparator.addItem(",");
        this.jComboSeparator.addItem(";");
        this.jComboSeparator.addItem("~");
        this.jComboSeparator.addItem("^");
    }

    public void resetForm() {
        this.m_jLocation.setEnabled(false);
        this.jImport.setEnabled(false);
        this.jbtnReset.setEnabled(true);
        this.jFileRead.setEnabled(false);
        this.jFileName.setText(null);
        this.csvFileName = "";
        this.progress = 0;
        this.webPBar.setValue(this.progress.intValue());
        this.jTextUpdate.setText("");
        this.jTextRecords.setText("");
        this.qtyUpdates = 0;
    }

    @Override
    public boolean deactivate() {
        this.resetForm();
        return true;
    }

    private void checkFile(String CSVFileName) throws IOException {
        File f = new File(CSVFileName);
        if (f.exists()) {
            this.products = new CsvReader(CSVFileName, ',', Charset.forName("UTF-8"));
            this.products.setDelimiter(((String)this.jComboSeparator.getSelectedItem()).charAt(0));
            this.rowCount = 0;
            boolean i = false;
            while (this.products.readRecord()) {
                ++this.rowCount;
            }
            this.jTextRecords.setText(Long.toString(this.rowCount));
            this.products.close();
            JOptionPane.showMessageDialog(null, "File Check " + CSVFileName, "File read OK", 2);
            this.enableForm();
        } else {
            JOptionPane.showMessageDialog(null, "Unable to locate " + CSVFileName, "File not found", 2);
        }
    }

    private void ImportCsvFile(String CSVFileName) throws IOException {
        File f = new File(CSVFileName);
        if (f.exists()) {
            this.webPBar.setString("Starting...");
            this.webPBar.setVisible(true);
            this.jImport.setEnabled(true);
            this.products = new CsvReader(CSVFileName, ',', Charset.forName("UTF-8"));
            this.products.setDelimiter(((String)this.jComboSeparator.getSelectedItem()).charAt(0));
            this.currentRecord = 0;
            while (this.products.readRecord()) {
                this.recordType = "delete";
                this.deleteRecord(this.recordType);
            }
            this.products.close();
            this.products = new CsvReader(CSVFileName, ',', Charset.forName("UTF-8"));
            this.products.setDelimiter(((String)this.jComboSeparator.getSelectedItem()).charAt(0));
            this.currentRecord = 0;
            while (this.products.readRecord()) {
                ++this.currentRecord;
                this.progress = this.currentRecord;
                this.recordType = "update";
                this.updateRecord(this.recordType);
            }
            this.products.close();
        } else {
            JOptionPane.showMessageDialog(null, "Unable to locate " + CSVFileName, "File not found", 2);
        }
        this.jTextUpdate.setText(Integer.toString(this.qtyUpdates));
        JOptionPane.showMessageDialog(null, "Import Complete", "Imported", 2);
        this.progress = 100;
        this.webPBar.setValue(this.progress.intValue());
        this.webPBar.setString("Imported" + this.progress);
    }

    private void updateRecord(String pId) throws IOException {
        this.prodInfo = new ProductInfoExt();
        this.prodStock = new ProductStock();
        try {
            String sCode = this.products.get(0);
            this.prodInfo = this.m_dlSales.getProductInfoByCode(sCode);
            if (this.prodInfo != null) {
                this.prodStock = this.m_dlSales.getProductStockState(this.prodInfo.getID(), this.m_sInventoryLocation);
                this.productBarcode = this.products.get(0);
                this.oldQty = this.prodStock.getUnits();
                this.newQty = Double.valueOf(this.products.get(1));
                this.productQty = this.oldQty + this.newQty;
                this.updateStockCurrent(this.m_sInventoryLocation, this.prodInfo.getID(), this.productQty);
                this.CSVStockUpdate(this.Location, this.productBarcode, this.newQty);
                ++this.qtyUpdates;
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void deleteRecord(String pId) throws IOException {
        this.prodInfo = new ProductInfoExt();
        this.prodStock = new ProductStock();
        try {
            String sCode = this.products.get(0);
            this.prodInfo = this.m_dlSales.getProductInfoByCode(sCode);
            if (this.prodInfo != null) {
                this.prodStock = this.m_dlSales.getProductStockState(this.prodInfo.getID(), this.m_sInventoryLocation);
                this.productQty = 0.0;
                this.deleteStockCurrent(this.m_sInventoryLocation, this.prodInfo.getID(), this.productQty);
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addStockCurrent(String LocationID, String ProductID, Double Units) throws BasicException {
        Object[] values = new Object[]{LocationID, ProductID, (double)Units};
        PreparedSentence sentence = new PreparedSentence(this.s, "INSERT INTO stockcurrent ( LOCATION, PRODUCT, UNITS) VALUES (?, ?, ?)", new SerializerWriteBasicExt(new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE}, new int[]{0, 1, 2}));
        sentence.exec(values);
    }

    public void updateStockCurrent(String LocationID, String ProductID, Double Units) throws BasicException {
        Object[] newValues = new Object[]{(double)Units, LocationID, ProductID};
        PreparedSentence sentence = new PreparedSentence(this.s, "UPDATE stockcurrent SET UNITS = ? WHERE LOCATION = ? AND PRODUCT = ?", new SerializerWriteBasicExt(new Datas[]{Datas.DOUBLE, Datas.STRING, Datas.STRING}, new int[]{0, 1, 2}));
        sentence.exec(newValues);
    }

    public void deleteStockCurrent(String LocationID, String ProductID, Double Units) throws BasicException {
        Object[] oldValues = new Object[]{(double)Units, LocationID, ProductID};
        PreparedSentence sentence = new PreparedSentence(this.s, "UPDATE stockcurrent SET UNITS = ? WHERE LOCATION = ? AND PRODUCT = ?", new SerializerWriteBasicExt(new Datas[]{Datas.DOUBLE, Datas.STRING, Datas.STRING}, new int[]{0, 1, 2}));
        sentence.exec(oldValues);
    }

    public void CSVStockUpdate(String LocationID, String Code, Double Units) {
        Object[] myprod = new Object[]{UUID.randomUUID().toString(), Integer.toString(this.currentRecord), "Qty update", this.Location, this.productBarcode, this.newQty};
        try {
            this.m_dlSystem.execCSVStockUpdate(myprod);
        }
        catch (BasicException ex) {
            Logger.getLogger(JPanelCSVImport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setWorker() {
        this.progress = 0;
        this.webPBar.setStringPainted(true);
        SwingWorker<Integer, Integer> pbWorker = new SwingWorker<Integer, Integer>(){

            @Override
            protected final Integer doInBackground() throws Exception {
                while (StockQtyImport.this.progress >= 0 && StockQtyImport.this.progress < 100) {
                    Thread.sleep(50L);
                    this.publish(StockQtyImport.this.progress);
                }
                this.publish(100);
                this.done();
                return 100;
            }

            @Override
            protected final void process(List<Integer> chunks) {
                StockQtyImport.this.webPBar.setValue(chunks.get(0).intValue());
                if (StockQtyImport.this.progress > 100) {
                    StockQtyImport.this.progress = 100;
                    StockQtyImport.this.webPBar.setString("Imported 100%");
                } else {
                    StockQtyImport.this.webPBar.setString("Imported " + StockQtyImport.this.progress + "%");
                }
            }
        };
        pbWorker.execute();
    }

    private void initComponents() {
        this.jFileChooserPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jFileName = new JTextField();
        this.jLabel18 = new JLabel();
        this.jbtnFileChoose = new JButton();
        this.jComboSeparator = new JComboBox();
        this.jFileRead = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jTextUpdates = new JLabel();
        this.jTextRecords = new JTextField();
        this.jTextUpdate = new JTextField();
        this.webPBar = new WebProgressBar();
        this.m_jLocation = new JLabel();
        this.jImport = new JButton();
        this.jbtnReset = new JButton();
        this.jLabel2 = new JLabel();
        this.setFont(new Font("Arial", 0, 14));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(700, 350));
        this.jLabel1.setFont(new Font("Arial", 0, 14));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jLabel1.setText(bundle.getString("label.csvfile"));
        this.jLabel1.setPreferredSize(new Dimension(100, 30));
        this.jFileName.setFont(new Font("Arial", 0, 14));
        this.jFileName.setPreferredSize(new Dimension(300, 30));
        this.jFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockQtyImport.this.jFileNameActionPerformed(evt);
            }
        });
        this.jLabel18.setFont(new Font("Arial", 0, 14));
        this.jLabel18.setText(bundle.getString("label.csvdelimit"));
        this.jLabel18.setPreferredSize(new Dimension(100, 30));
        this.jbtnFileChoose.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/fileopen.png")));
        this.jbtnFileChoose.setMaximumSize(new Dimension(64, 32));
        this.jbtnFileChoose.setMinimumSize(new Dimension(64, 32));
        this.jbtnFileChoose.setPreferredSize(new Dimension(80, 45));
        this.jbtnFileChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockQtyImport.this.jbtnFileChooseActionPerformed(evt);
            }
        });
        this.jComboSeparator.setFont(new Font("Arial", 0, 12));
        this.jComboSeparator.setPreferredSize(new Dimension(50, 30));
        GroupLayout jFileChooserPanelLayout = new GroupLayout(this.jFileChooserPanel);
        this.jFileChooserPanel.setLayout(jFileChooserPanelLayout);
        jFileChooserPanelLayout.setHorizontalGroup(jFileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jFileChooserPanelLayout.createSequentialGroup().addGroup(jFileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jFileChooserPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFileName, -2, -1, -2)).addGroup(jFileChooserPanelLayout.createSequentialGroup().addComponent(this.jLabel18, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jbtnFileChoose, -2, -1, -2))).addContainerGap()));
        jFileChooserPanelLayout.setVerticalGroup(jFileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jFileChooserPanelLayout.createSequentialGroup().addGroup(jFileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jFileName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jFileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel18, -2, -1, -2).addComponent(this.jComboSeparator, -2, -1, -2).addComponent(this.jbtnFileChoose, -2, -1, -2)).addContainerGap()));
        this.jFileRead.setFont(new Font("Arial", 0, 12));
        this.jFileRead.setText(bundle.getString("label.csvread"));
        this.jFileRead.setEnabled(false);
        this.jFileRead.setPreferredSize(new Dimension(85, 45));
        this.jFileRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockQtyImport.this.jFileReadActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(153, 153, 153), 1, true), bundle.getString("title.CSVImport"), 0, 0, new Font("Arial", 1, 14), new Color(102, 102, 102)));
        this.jLabel9.setFont(new Font("Arial", 0, 14));
        this.jLabel9.setText(bundle.getString("label.csvrecordsfound"));
        this.jLabel9.setPreferredSize(new Dimension(150, 30));
        this.jTextUpdates.setFont(new Font("Arial", 0, 14));
        this.jTextUpdates.setText(bundle.getString("label.csvchanged"));
        this.jTextUpdates.setPreferredSize(new Dimension(150, 30));
        this.jTextRecords.setFont(new Font("Arial", 0, 14));
        this.jTextRecords.setForeground(new Color(102, 102, 102));
        this.jTextRecords.setHorizontalAlignment(4);
        this.jTextRecords.setBorder(null);
        this.jTextRecords.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextRecords.setEnabled(false);
        this.jTextRecords.setPreferredSize(new Dimension(100, 30));
        this.jTextUpdate.setFont(new Font("Arial", 0, 14));
        this.jTextUpdate.setForeground(new Color(102, 102, 102));
        this.jTextUpdate.setHorizontalAlignment(4);
        this.jTextUpdate.setBorder(null);
        this.jTextUpdate.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextUpdate.setEnabled(false);
        this.jTextUpdate.setPreferredSize(new Dimension(100, 30));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextRecords, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextUpdates, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextUpdate, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9, -2, -1, -2).addComponent(this.jTextRecords, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextUpdates, -2, -1, -2).addComponent(this.jTextUpdate, -2, -1, -2)).addGap(47, 47, 47)));
        this.webPBar.setFont(new Font("Arial", 0, 13));
        this.webPBar.setPreferredSize(new Dimension(240, 30));
        this.m_jLocation.setFont(new Font("Arial", 0, 14));
        this.m_jLocation.setHorizontalAlignment(0);
        this.m_jLocation.setText(bundle.getString("label.location"));
        this.m_jLocation.setPreferredSize(new Dimension(100, 30));
        this.jImport.setFont(new Font("Arial", 0, 12));
        this.jImport.setText(bundle.getString("label.csvimpostbtn"));
        this.jImport.setEnabled(false);
        this.jImport.setPreferredSize(new Dimension(85, 45));
        this.jImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockQtyImport.this.jImportActionPerformed(evt);
            }
        });
        this.jbtnReset.setFont(new Font("Arial", 0, 12));
        this.jbtnReset.setText(bundle.getString("button.reset"));
        this.jbtnReset.setPreferredSize(new Dimension(85, 45));
        this.jbtnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StockQtyImport.this.jbtnResetActionPerformed(evt);
            }
        });
        this.jLabel2.setBackground(new Color(255, 255, 255));
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText(bundle.getString("label.csvnotice"));
        this.jLabel2.setVerticalAlignment(1);
        this.jLabel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jLabel2.setOpaque(true);
        this.jLabel2.setPreferredSize(new Dimension(710, 110));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jFileChooserPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.m_jLocation, -2, 295, -2).addGroup(layout.createSequentialGroup().addComponent(this.jFileRead, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jImport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnReset, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.webPBar, -2, 284, -2).addComponent(this.jPanel2, -2, -1, -2))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jFileChooserPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jLocation, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jFileRead, -2, -1, -2).addComponent(this.jImport, -2, -1, -2).addComponent(this.jbtnReset, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent((Component)this.webPBar, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2))).addGap(10, 10, 10).addComponent(this.jLabel2, -1, -1, -2).addContainerGap()));
    }

    private void jFileReadActionPerformed(ActionEvent evt) {
        try {
            this.checkFile(this.jFileName.getText());
            this.webPBar.setString("Source file OK");
            this.m_jLocation.setEnabled(true);
        }
        catch (IOException ex) {
            Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
            this.webPBar.setString("Source file error!");
            this.m_jLocation.setEnabled(false);
        }
    }

    private void jFileNameActionPerformed(ActionEvent evt) {
        this.jImport.setEnabled(false);
        this.jFileRead.setEnabled(true);
    }

    private void jbtnFileChooseActionPerformed(ActionEvent evt) {
        String csv;
        this.resetForm();
        this.setWorker();
        JFileChooser chooser = new JFileChooser(this.last_folder == null ? "C:\\" : this.last_folder);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("csv files", "csv");
        chooser.setFileFilter(filter);
        chooser.showOpenDialog(null);
        File csvFile = chooser.getSelectedFile();
        if (csvFile == null) {
            return;
        }
        File current_folder = chooser.getCurrentDirectory();
        if (this.last_folder == null || !this.last_folder.equals(current_folder.getAbsolutePath())) {
            AppConfig CSVConfig = new AppConfig(this.config_file);
            CSVConfig.load();
            CSVConfig.setProperty("CSV.last_folder", current_folder.getAbsolutePath());
            this.last_folder = current_folder.getAbsolutePath();
            try {
                CSVConfig.save();
            }
            catch (IOException ex) {
                Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!(csv = csvFile.getName()).trim().equals("")) {
            this.csvFileName = csvFile.getAbsolutePath();
            this.jFileName.setText(this.csvFileName);
            this.jFileRead.setEnabled(true);
        }
    }

    private void jbtnResetActionPerformed(ActionEvent evt) {
        this.resetForm();
        this.progress = 0;
        this.webPBar.setString("Waiting...");
    }

    private void jImportActionPerformed(ActionEvent evt) {
        this.jFileRead.setEnabled(false);
        this.jImport.setEnabled(false);
        workProcess work = new workProcess();
        Thread thread2 = new Thread(work);
        thread2.start();
    }

    private class workProcess
    implements Runnable {
        private workProcess() {
        }

        @Override
        public void run() {
            try {
                StockQtyImport.this.ImportCsvFile(StockQtyImport.this.jFileName.getText());
            }
            catch (IOException ex) {
                Logger.getLogger(StockQtyImport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

