//    uniCenta oPOS - Touch Friendly Point Of Sales
//    Copyright (c) 2009-2018 uniCenta
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Suppliers.Reports.Sales");
report.setReport("/com/openbravo/reports/suppliers_sales");
report.setResourceBundle("com/openbravo/reports/suppliers_messages");

report.setSentence("SELECT " +
       "suppliers.name AS SNAME, products.name AS PNAME, " +
       "tickets.ticketid, tickets.tickettype, " +
       "SUM(ticketlines.units) AS UNITS, " +
       "SUM(ticketlines.units * ticketlines.price) AS TOTAL, " +
       "receipts.datenew " +
  "FROM receipts, suppliers, tickets, ticketlines LEFT OUTER JOIN products ON ticketlines.product = products.id " +
  "WHERE suppliers.id = products.supplier " +
		"AND ticketlines.product = products.id " +
		"AND receipts.id = tickets.id " +
		"AND tickets.id = ticketlines.ticket " +
                "AND ?(QBF_FILTER) " +
  "GROUP BY suppliers.name, receipts.datenew, tickets.id, products.name,tickets.tickettype " +
  "ORDER BY suppliers.name, products.name, receipts.datenew");

report.addParameter("receipts.datenew");
report.addParameter("receipts.datenew");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("suppliers.id");
report.addParameter("suppliers.name");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsSuppliers());

report.addField("SNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("PNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("TICKETID", com.openbravo.data.loader.Datas.STRING);
report.addField("TICKETTYPE", com.openbravo.data.loader.Datas.INT);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("DATENEW", com.openbravo.data.loader.Datas.TIMESTAMP);

report;