/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.data.gui;

import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.LocalRes;
import com.openbravo.data.user.BrowsableEditableData;
import com.openbravo.data.user.StateListener;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class JSaver
extends JPanel
implements StateListener {
    protected BrowsableEditableData m_bd;
    private JButton jbtnDelete;
    private JButton jbtnNew;
    private JButton jbtnSave;

    public JSaver(BrowsableEditableData bd) {
        this.initComponents();
        this.m_bd = bd;
        this.m_bd.addStateListener(this);
    }

    @Override
    public void updateState(int iState) {
        switch (iState) {
            case 3: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(this.m_bd.canInsertData());
                break;
            }
            case 2: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(this.m_bd.canDeleteData());
                break;
            }
            case 0: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(false);
                break;
            }
            case 1: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(this.m_bd.canDeleteData());
                this.jbtnSave.setEnabled(this.m_bd.canUpdateData());
            }
        }
    }

    private void initComponents() {
        this.jbtnNew = new JButton();
        this.jbtnDelete = new JButton();
        this.jbtnSave = new JButton();
        this.jbtnNew.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/editnew.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jbtnNew.setToolTipText(bundle.getString("tooltip.addnew"));
        this.jbtnNew.setFocusPainted(false);
        this.jbtnNew.setFocusable(false);
        this.jbtnNew.setMargin(new Insets(2, 2, 2, 2));
        this.jbtnNew.setPreferredSize(new Dimension(60, 45));
        this.jbtnNew.setRequestFocusEnabled(false);
        this.jbtnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnNewActionPerformed(evt);
            }
        });
        this.jbtnDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_delete.png")));
        this.jbtnDelete.setToolTipText(bundle.getString("tooltip.delete"));
        this.jbtnDelete.setFocusPainted(false);
        this.jbtnDelete.setFocusable(false);
        this.jbtnDelete.setMargin(new Insets(2, 2, 2, 2));
        this.jbtnDelete.setPreferredSize(new Dimension(60, 45));
        this.jbtnDelete.setRequestFocusEnabled(false);
        this.jbtnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnDeleteActionPerformed(evt);
            }
        });
        this.jbtnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/filesave.png")));
        this.jbtnSave.setToolTipText(bundle.getString("tooltip.save"));
        this.jbtnSave.setFocusPainted(false);
        this.jbtnSave.setFocusable(false);
        this.jbtnSave.setMargin(new Insets(2, 2, 2, 2));
        this.jbtnSave.setPreferredSize(new Dimension(60, 45));
        this.jbtnSave.setRequestFocusEnabled(false);
        this.jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jbtnNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbtnSave, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jbtnNew, -2, -1, -2).addComponent(this.jbtnDelete, -2, -1, -2).addComponent(this.jbtnSave, -2, -1, -2));
    }

    private void jbtnSaveActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.saveData();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nosave"), eD);
            msg.show(this);
        }
    }

    private void jbtnDeleteActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.actionDelete();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nodelete"), eD);
            msg.show(this);
        }
    }

    private void jbtnNewActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.actionInsert();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nonew"), eD);
            msg.show(this);
        }
    }
}

